<?php

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }


/* Theme setup section
-------------------------------------------------------------------- */

if ( !function_exists( 'royal_event_template_header_5_theme_setup' ) ) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_template_header_5_theme_setup', 1 );
	function royal_event_template_header_5_theme_setup() {
		royal_event_add_template(array(
			'layout' => 'header_5',
			'mode'   => 'header',
			'title'  => esc_html__('Header 5', 'royal-event'),
			'icon'   => royal_event_get_file_url('templates/headers/images/5.jpg')
			));
	}
}

// Template output
if ( !function_exists( 'royal_event_template_header_5_output' ) ) {
	function royal_event_template_header_5_output($post_options, $post_data) {

		// WP custom header
		$header_css = '';
		if ($post_options['position'] != 'over') {
			$header_image = get_header_image();
			$header_css = $header_image!='' 
				? ' style="background-image: url('.esc_url($header_image).')"' 
				: '';
		}
		?>

		<div class="top_panel_fixed_wrap"></div>

		<header class="top_panel_wrap top_panel_style_5 scheme_<?php echo esc_attr($post_options['scheme']); ?>">
			<div class="top_panel_wrap_inner top_panel_inner_style_5 top_panel_position_<?php echo esc_attr(royal_event_get_custom_option('top_panel_position')); ?>">
			
			<?php if (royal_event_get_custom_option('show_top_panel_top')=='yes') { ?>
				<div class="top_panel_top">
					<div class="content_wrap clearfix">
						<?php
						royal_event_template_set_args('top-panel-top', array(
                            'top_panel_top_components' => array('contact_info', 'search', 'login', 'socials', 'bookmarks')
                        ));
						get_template_part(royal_event_get_file_slug('templates/headers/_parts/top-panel-top.php'));
						?>
					</div>
				</div>
			<?php } ?>

			<div class="top_panel_middle" <?php royal_event_show_layout($header_css); ?>>
				<div class="menu_main_wrap clearfix">
					<nav class="menu_main_nav_area menu_hover_<?php echo esc_attr(royal_event_get_theme_option('menu_hover')); ?>">
						<?php
						$menu_main = royal_event_get_nav_menu('menu_main');
						if (empty($menu_main)) $menu_main = royal_event_get_nav_menu();
						royal_event_show_layout($menu_main);
						?>
					</nav>
				</div>
				<div class="content_wrap">
					<div class="contact_info">
					<?php
						if (($contact_phone=trim(royal_event_get_custom_option('contact_phone')))!='') {
							?>
							<div class="top_panel_middle_contact_area contact_phone">
								<span class="icon-phone"></span>
								<a href="tel:<?php echo esc_attr($contact_phone); ?>"><?php royal_event_show_layout($contact_phone); ?></a>
							</div>
							<?php
						}
                        if (($contact_email=trim(royal_event_get_custom_option('contact_email')))!='') {
                            ?><div class="top_panel_middle_contact_area">
							<a href="mailto:<?php echo antispambot($contact_email); ?>"><?php royal_event_show_layout($contact_email); ?></a>
                            </div><?php
                        }
                    ?>
					</div>
					<div class="contact_logo">
						<?php royal_event_show_logo(true, true); ?>
					</div>
					<div class="contact_cart">
					<?php
						if (function_exists('royal_event_exists_woocommerce') && royal_event_exists_woocommerce() && (royal_event_is_woocommerce_page() || royal_event_get_custom_option('show_cart')!='hide') && royal_event_get_custom_option('show_cart')!='hide' && !(is_checkout() || is_cart() || defined('WOOCOMMERCE_CHECKOUT') || defined('WOOCOMMERCE_CART'))) {
							?>
							<div class="menu_main_cart">
								<?php get_template_part(royal_event_get_file_slug('templates/headers/_parts/contact-info-cart.php')); ?>
							</div>
							<?php
						}
					?>
					</div>
				</div>
			</div>

			</div>
		</header>

		<?php
		royal_event_storage_set('header_mobile', array(
				 'open_hours' => false,
				 'login' => false,
				 'socials' => false,
				 'bookmarks' => false,
				 'contact_address' => false,
				 'contact_phone_email' => false,
				 'woo_cart' => false,
				 'search' => false
			)
		);
	}
}
?>