<?php
/**
 * Royal Event Framework: MenuItems support
 *
 * @package	royal_event
 * @since	royal_event 3.5
 */

// Theme init
if (!function_exists('royal_event_menuitems_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_menuitems_theme_setup', 1 );
	function royal_event_menuitems_theme_setup() {

		// Detect current page type, taxonomy and title (for custom post_types use priority < 10 to fire it handles early, than for standard post types)
		add_filter('royal_event_filter_get_blog_type',			'royal_event_menuitems_get_blog_type', 9, 2);
		add_filter('royal_event_filter_get_blog_title',		'royal_event_menuitems_get_blog_title', 9, 2);
		add_filter('royal_event_filter_get_current_taxonomy',	'royal_event_menuitems_get_current_taxonomy', 9, 2);
		add_filter('royal_event_filter_is_taxonomy',			'royal_event_menuitems_is_taxonomy', 9, 2);
		add_filter('royal_event_filter_get_stream_page_title',	'royal_event_menuitems_get_stream_page_title', 9, 2);
		add_filter('royal_event_filter_get_stream_page_link',	'royal_event_menuitems_get_stream_page_link', 9, 2);
		add_filter('royal_event_filter_get_stream_page_id',	'royal_event_menuitems_get_stream_page_id', 9, 2);
		add_filter('royal_event_filter_query_add_filters',		'royal_event_menuitems_query_add_filters', 9, 2);
		add_filter('royal_event_filter_detect_inheritance_key','royal_event_menuitems_detect_inheritance_key', 9, 1);
		
		add_action('wp_ajax_ajax_menuitem',			'royal_event_callback_ajax_menuitem');
		add_action('wp_ajax_nopriv_ajax_menuitem',	'royal_event_callback_ajax_menuitem');
		
		// Extra column for menuitems lists
		if (royal_event_get_theme_option('show_overriden_posts')=='yes') {
			add_filter('manage_edit-menuitems_columns',			'royal_event_post_add_options_column', 9);
			add_filter('manage_menuitems_posts_custom_column',	'royal_event_post_fill_options_column', 9, 2);
		}
		
		// Add supported data types
		royal_event_theme_support_pt('menuitems');
		royal_event_theme_support_tx('menuitems_group');
	}
}

if ( !function_exists( 'royal_event_menuitems_settings_theme_setup2' ) ) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_menuitems_settings_theme_setup2', 3 );
	function royal_event_menuitems_settings_theme_setup2() {
		// Add post type 'menuitems' and taxonomy 'menuitems_group' into theme inheritance list
		royal_event_add_theme_inheritance( array('menuitems' => array(
			'stream_template' => 'blog-menuitems',
			'single_template' => 'single-menuitems',
			'taxonomy' => array('menuitems_group'),
			'taxonomy_tags' => array(),
			'post_type' => array('menuitems'),
			'override' => 'custom'
			) )
		);
	}
}



if (!function_exists('royal_event_menuitems_after_theme_setup')) {
	add_action( 'royal_event_action_after_init_theme', 'royal_event_menuitems_after_theme_setup' );
	function royal_event_menuitems_after_theme_setup() {
		// Update fields in the override options
		if (royal_event_storage_get_array('post_override_options', 'page')=='menuitems') {

			// override options fields
			royal_event_storage_set_array('post_override_options', 'title', esc_html__('MenuItem Options', 'royal-event'));
			royal_event_storage_set_array('post_override_options', 'fields', array(

				"mb_partition_menuitems" => array(
					"title" => esc_html__('MenuItems', 'royal-event'),
					"override" => "page,post,custom",
					"divider" => false,
					"icon" => "icon-th-list",
					"type" => "partition"),

				"mb_info_menuitems_1" => array(
					"title" => esc_html__('MenuItem details', 'royal-event'),
					"override" => "page,post,custom",
					"divider" => false,
					"desc" => wp_kses_data( __('In this section you can put details for this menuitem', 'royal-event') ),
					"class" => "menuitem_meta",
					"type" => "info"),
				"menuitem_price" => array(
					"title" => esc_html__('Price',  'royal-event'),
					"desc" => '',
					"override" => "page,post,custom",
					"class" => "menuitem_price",
					"std" => '',
					"type" => "text"),
				"menuitem_spicylevel" => array(
					"title" => esc_html__("Spicy Level", 'royal-event'),
					"desc" => '',
					"override" => "page,post,custom",
					"class" => "menuitem_spicylevel",
					"std" => 0,
					"min" => 0,
					"max" => 5,
					"step" => 1,
					"type" => "spinner"),
				"menuitem_new" => array(
                    "title" => esc_html__("New Item", 'royal-event'),
                    "desc" => '',
                    "override" => "page,post,custom",
                    "class" => "menuitem_new",
                    "std" => "no",
                    "options" => array(
                        'yes' => "Yes",
                        'no' => "No",
                    ),
                    "type" => "switch"
                ),
				
				
				"mb_info_menuitems_2" => array(
					"title" => esc_html__('Nutritional Information', 'royal-event'),
					"override" => "page,post,custom",
					"divider" => false,
					"desc" => '',
					"class" => "menuitem_nutritional",
					"type" => "info"),
				"menuitem_calories" => array(
					"title" => esc_html__('Calories',  'royal-event'),
					"desc" => wp_kses_data( __("Calories in: Kcal", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_calories",
					"std" => '',
					"type" => "text"),
				"menuitem_cholesterol" => array(
					"title" => esc_html__('Cholesterol',  'royal-event'),
					"desc" => wp_kses_data( __("Cholesterol in: mg", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_cholesterol",
					"std" => '',
					"type" => "text"),
				"menuitem_fiber" => array(
					"title" => esc_html__('Fiber',  'royal-event'),
					"desc" => wp_kses_data( __("Fiber in: g", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_fiber",
					"std" => '',
					"type" => "text"),
				"menuitem_sodium" => array(
					"title" => esc_html__('Sodium',  'royal-event'),
					"desc" => wp_kses_data( __("Sodium in: mg", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_sodium",
					"std" => '',
					"type" => "text"),
				"menuitem_carbohydrates" => array(
					"title" => esc_html__('Carbohydrates',  'royal-event'),
					"desc" => wp_kses_data( __("Carbohydrates in: g", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_carbohydrates",
					"std" => '',
					"type" => "text"),
				"menuitem_fat" => array(
					"title" => esc_html__('Fat',  'royal-event'),
					"desc" => wp_kses_data( __("Fat in: g", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_fat",
					"std" => '',
					"type" => "text"),
				"menuitem_protein" => array(
					"title" => esc_html__('Protein',  'royal-event'),
					"desc" => wp_kses_data( __("Protein in: g", 'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_protein",
					"std" => '',
					"type" => "text"),
				"menuitem_ingredients" => array(
					"title" => esc_html__('Ingredients',  'royal-event'),
					"desc" => wp_kses_data( __('One ingredient in row',  'royal-event') ),
					"override" => "page,post,custom",
					"class" => "menuitem_ingredients",
					"std" => "",
					"allow_html" => true,
					"allow_js" => true,
					"type" => "textarea"),
				"menuitem_product" => array(
					"title" => esc_html__('Link to product',  'royal-event'),
					"desc" => esc_html__("Link to product page for this menu items", 'royal-event'),
					"override" => "page,post,custom",
					"class" => "menuitem_product",
					"std" => '',
					"options" => royal_event_get_list_posts(false, 'product'),
					"type" => "select")
				
				)
			);
		}
	}
}


// Return true, if current page is menuitems page
if ( !function_exists( 'royal_event_is_menuitems_page' ) ) {
	function royal_event_is_menuitems_page() {
		$is = in_array(royal_event_storage_get('page_template'), array('blog-menuitems', 'single-menuitem'));
		if (!$is) {
			if (!royal_event_storage_empty('pre_query'))
				$is = royal_event_storage_call_obj_method('pre_query', 'get', 'post_type')=='menuitems'
						|| royal_event_storage_call_obj_method('pre_query', 'is_tax', 'menuitems_group') 
						|| (royal_event_storage_call_obj_method('pre_query', 'is_page') 
							&& ($id=royal_event_get_template_page_id('blog-menuitems')) > 0 
							&& $id==royal_event_storage_get_obj_property('pre_query', 'queried_object_id', 0)
							);
			else
				$is = get_query_var('post_type')=='menuitems' 
						|| is_tax('menuitems_group') 
						|| (is_page() && ($id=royal_event_get_template_page_id('blog-menuitems')) > 0 && $id==get_the_ID());
		}
		return $is;
	}
}

// Filter to detect current page inheritance key
if ( !function_exists( 'royal_event_menuitems_detect_inheritance_key' ) ) {
	//Handler of add_filter('royal_event_filter_detect_inheritance_key',	'royal_event_menuitems_detect_inheritance_key', 9, 1);
	function royal_event_menuitems_detect_inheritance_key($key) {
		if (!empty($key)) return $key;
		return royal_event_is_menuitems_page() ? 'menuitems' : '';
	}
}

// Filter to detect current page slug
if ( !function_exists( 'royal_event_menuitems_get_blog_type' ) ) {
	//Handler of add_filter('royal_event_filter_get_blog_type',	'royal_event_menuitems_get_blog_type', 9, 2);
	function royal_event_menuitems_get_blog_type($page, $query=null) {
		if (!empty($page)) return $page;
		if ($query && $query->is_tax('menuitems_group') || is_tax('menuitems_group'))
			$page = 'menuitems_category';
		else if ($query && $query->get('post_type')=='menuitems' || get_query_var('post_type')=='menuitems')
			$page = $query && $query->is_single() || is_single() ? 'menuitems_item' : 'menuitems';
		return $page;
	}
}

// Filter to detect current page title
if ( !function_exists( 'royal_event_menuitems_get_blog_title' ) ) {
	//Handler of add_filter('royal_event_filter_get_blog_title',	'royal_event_menuitems_get_blog_title', 9, 2);
	function royal_event_menuitems_get_blog_title($title, $page) {
		if (!empty($title)) return $title;
		if ( royal_event_strpos($page, 'menuitems')!==false ) {
			if ( $page == 'menuitems_category' ) {
				$term = get_term_by( 'slug', get_query_var( 'menuitems_group' ), 'menuitems_group', OBJECT);
				$title = $term->name;
			} else if ( $page == 'menuitems_item' ) {
				$title = royal_event_get_post_title();
			} else {
				$title = esc_html__('All menuitems', 'royal-event');
			}
		}
		return $title;
	}
}

// Filter to detect stream page title
if ( !function_exists( 'royal_event_menuitems_get_stream_page_title' ) ) {
	//Handler of add_filter('royal_event_filter_get_stream_page_title',	'royal_event_menuitems_get_stream_page_title', 9, 2);
	function royal_event_menuitems_get_stream_page_title($title, $page) {
		if (!empty($title)) return $title;
		if (royal_event_strpos($page, 'menuitems')!==false) {
			if (($page_id = royal_event_menuitems_get_stream_page_id(0, $page=='menuitems' ? 'blog-menuitems' : $page)) > 0)
				$title = royal_event_get_post_title($page_id);
			else
				$title = esc_html__('All menuitems', 'royal-event');				
		}
		return $title;
	}
}

// Filter to detect stream page ID
if ( !function_exists( 'royal_event_menuitems_get_stream_page_id' ) ) {
	//Handler of add_filter('royal_event_filter_get_stream_page_id',	'royal_event_menuitems_get_stream_page_id', 9, 2);
	function royal_event_menuitems_get_stream_page_id($id, $page) {
		if (!empty($id)) return $id;
		if (royal_event_strpos($page, 'menuitems')!==false) $id = royal_event_get_template_page_id('blog-menuitems');
		return $id;
	}
}

// Filter to detect stream page URL
if ( !function_exists( 'royal_event_menuitems_get_stream_page_link' ) ) {
	//Handler of add_filter('royal_event_filter_get_stream_page_link',	'royal_event_menuitems_get_stream_page_link', 9, 2);
	function royal_event_menuitems_get_stream_page_link($url, $page) {
		if (!empty($url)) return $url;
		if (royal_event_strpos($page, 'menuitems')!==false) {
			$id = royal_event_get_template_page_id('blog-menuitems');
			if ($id) $url = get_permalink($id);
		}
		return $url;
	}
}

// Filter to detect current taxonomy
if ( !function_exists( 'royal_event_menuitems_get_current_taxonomy' ) ) {
	//Handler of add_filter('royal_event_filter_get_current_taxonomy',	'royal_event_menuitems_get_current_taxonomy', 9, 2);
	function royal_event_menuitems_get_current_taxonomy($tax, $page) {
		if (!empty($tax)) return $tax;
		if ( royal_event_strpos($page, 'menuitems')!==false ) {
			$tax = 'menuitems_group';
		}
		return $tax;
	}
}

// Return taxonomy name (slug) if current page is this taxonomy page
if ( !function_exists( 'royal_event_menuitems_is_taxonomy' ) ) {
	//Handler of add_filter('royal_event_filter_is_taxonomy',	'royal_event_menuitems_is_taxonomy', 9, 2);
	function royal_event_menuitems_is_taxonomy($tax, $query=null) {
		if (!empty($tax))
			return $tax;
		else 
			return $query && $query->get('menuitems_group')!='' || is_tax('menuitems_group') ? 'menuitems_group' : '';
	}
}

// Add custom post type and/or taxonomies arguments to the query
if ( !function_exists( 'royal_event_menuitems_query_add_filters' ) ) {
	//Handler of add_filter('royal_event_filter_query_add_filters',	'royal_event_menuitems_query_add_filters', 9, 2);
	function royal_event_menuitems_query_add_filters($args, $filter) {
		if ($filter == 'menuitems') {
			$args['post_type'] = 'menuitems';
		}
		return $args;
	}
}




// AJAX handler - return menuitems list
//----------------------------------------------------------------------------
if ( !function_exists( 'royal_event_callback_ajax_menuitem' ) ) {
	function royal_event_callback_ajax_menuitem() {
		
		if ( !wp_verify_nonce( royal_event_get_value_gp('nonce'), admin_url('admin-ajax.php') ) )
			wp_die();
		
		$response = array('error'=>'', 'data' => '');
		
		$id = royal_event_get_value_gp('text');
		
		$response['data'] = royal_event_sc_menuitems(array(
			'style' => 'menuitems-2',
			'columns' => '1',
			'popup' => 'no',
			'slider' => 'no',
			'custom' => 'no',
			'count' => '1',
			'offset' => '0',
			'orderby' => 'title',
			'order' => 'asc',
			'ids' => $id,
			'top' => 'inherit',
			'bottom' => 'inherit',
			'left' => 'inherit',
			'right' => 'inherit'
			));
		
		echo json_encode($response);
		wp_die();
	}
}
?>