<?php
/* WPML support functions
------------------------------------------------------------------------------- */

// Check if WPML installed and activated
if ( !function_exists( 'royal_event_exists_wpml' ) ) {
	function royal_event_exists_wpml() {
		return defined('ICL_SITEPRESS_VERSION') && class_exists('sitepress');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_wpml_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_wpml_required_plugins');
	function royal_event_wpml_required_plugins($list=array()) {
		if (in_array('wpml', royal_event_storage_get('required_plugins'))) {
			$path = royal_event_get_file_dir('plugins/install/wpml.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('WPML', 'royal-event'),
					'slug' 		=> 'wpml',
					'source'	=> $path,
					'required' 	=> false
					);
			}
		}
		return $list;
	}
}
?>