<?php
/* WordPress Social Login support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_wordpress_social_login_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_wordpress_social_login_theme_setup', 1 );
	function royal_event_wordpress_social_login_theme_setup() {
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',				'royal_event_wordpress_social_login_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_wordpress_social_login_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_wordpress_social_login_required_plugins');
	function royal_event_wordpress_social_login_required_plugins($list=array()) {
		if (in_array('wordpress-social-login', royal_event_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> 'WordPress Social Login',
                'slug' 		=> 'wordpress-social-login',
                'required' 	=> false
                );
		}
		return $list;
	}
}
?>