<?php
/* WPBakery PageBuilder support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_vc_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_vc_theme_setup', 1 );
	function royal_event_vc_theme_setup() {
		if (royal_event_exists_visual_composer()) {
			add_action('royal_event_action_add_styles',		 				'royal_event_vc_frontend_scripts' );
		}
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',					'royal_event_vc_required_plugins' );
		}
	}
}

// Check if WPBakery PageBuilder installed and activated
if ( !function_exists( 'royal_event_exists_visual_composer' ) ) {
	function royal_event_exists_visual_composer() {
		return class_exists('Vc_Manager');
	}
}

// Check if WPBakery PageBuilder in frontend editor mode
if ( !function_exists( 'royal_event_vc_is_frontend' ) ) {
	function royal_event_vc_is_frontend() {
		return (isset($_GET['vc_editable']) && $_GET['vc_editable']=='true')
			|| (isset($_GET['vc_action']) && $_GET['vc_action']=='vc_inline');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_vc_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_vc_required_plugins');
	function royal_event_vc_required_plugins($list=array()) {
		if (in_array('visual_composer', royal_event_storage_get('required_plugins'))) {
			$path = royal_event_get_file_dir('plugins/install/js_composer.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('WPBakery PageBuilder', 'royal-event'),
					'slug' 		=> 'js_composer',
                    'version'   => '6.9.0',
					'source'	=> $path,
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Enqueue VC custom styles
if ( !function_exists( 'royal_event_vc_frontend_scripts' ) ) {
	//Handler of add_action( 'royal_event_action_add_styles', 'royal_event_vc_frontend_scripts' );
	function royal_event_vc_frontend_scripts() {
		if (file_exists(royal_event_get_file_dir('css/plugin.visual-composer.css')))
			wp_enqueue_style( 'royal-event-plugin-visual-composer-style',  royal_event_get_file_url('css/plugin.visual-composer.css'), array(), null );
	}
}
?>