<?php
/* TRX Updater support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('royal_event_trx_updater_theme_setup9')) {
	add_action( 'after_setup_theme', 'royal_event_trx_updater_theme_setup9', 9 );
	function royal_event_trx_updater_theme_setup9() {
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',		'royal_event_trx_updater_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_trx_updater_required_plugins' ) ) {
	function royal_event_trx_updater_required_plugins($list=array()) {
		if (in_array('trx_updater', (array)royal_event_storage_get('required_plugins'))) {
            $path = royal_event_get_file_dir('plugins/install/trx_updater.zip');
			$list[] = array(
				'name' 		=> esc_html__('ThemeREX Updater', 'royal-event'),
				'slug' 		=> 'trx_updater',
				'version'	=> '1.9.9',
				'source'	=> !empty($path) ? $path : 'upload://trx_updater.zip',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( !function_exists( 'royal_event_exists_trx_updater' ) ) {
	function royal_event_exists_trx_updater() {
		return function_exists( 'trx_updater_load_plugin_textdomain' );
	}
}
