<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_revslider_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_revslider_theme_setup', 1 );
    function royal_event_revslider_theme_setup() {
        if (royal_event_exists_revslider()) {
            add_filter( 'royal_event_filter_list_sliders',					'royal_event_revslider_list_sliders' );
            add_filter( 'royal_event_filter_theme_options_params',			'royal_event_revslider_theme_options_params' );
        }
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins',				'royal_event_revslider_required_plugins' );
        }
    }
}

if ( !function_exists( 'royal_event_revslider_settings_theme_setup2' ) ) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_revslider_settings_theme_setup2', 3 );
    function royal_event_revslider_settings_theme_setup2() {
        if (royal_event_exists_revslider()) {

            // Add Revslider specific options in the Theme Options
            royal_event_storage_set_array_after('options', 'slider_engine', "slider_alias", array(
                    "title" => esc_html__('Revolution Slider: Select slider',  'royal-event'),
                    "desc" => wp_kses_data( __("Select slider to show (if engine=revo in the field above)", 'royal-event') ),
                    "override" => "category,services_group,custom,page",
                    "dependency" => array(
                        'show_slider' => array('yes'),
                        'slider_engine' => array('revo')
                    ),
                    "std" => "",
                    "options" => royal_event_get_options_param('list_revo_sliders'),
                    "type" => "select"
                )
            );

        }
    }
}

// Check if RevSlider installed and activated
if ( !function_exists( 'royal_event_exists_revslider' ) ) {
    function royal_event_exists_revslider() {
        return function_exists('rev_slider_shortcode');
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_revslider_required_plugins' ) ) {
    //Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_revslider_required_plugins');
    function royal_event_revslider_required_plugins($list=array()) {
        if (in_array('revslider', royal_event_storage_get('required_plugins'))) {
            $path = royal_event_get_file_dir('plugins/install/revslider.zip');
            if (file_exists($path)) {
                $list[] = array(
                    'name' 		=> esc_html__('Revolution Slider', 'royal-event'),
                    'slug' 		=> 'revslider',
                    'version'   => '6.6.1',
                    'source'	=> $path,
                    'required' 	=> false
                );
            }
        }
        return $list;
    }
}


// Lists
//------------------------------------------------------------------------

// Add RevSlider in the sliders list, prepended inherit (if need)
if ( !function_exists( 'royal_event_revslider_list_sliders' ) ) {
    //Handler of add_filter( 'royal_event_filter_list_sliders',					'royal_event_revslider_list_sliders' );
    function royal_event_revslider_list_sliders($list=array()) {
        $list["revo"] = esc_html__("Layer slider (Revolution)", 'royal-event');
        return $list;
    }
}

// Return Revo Sliders list, prepended inherit (if need)
if ( !function_exists( 'royal_event_get_list_revo_sliders' ) ) {
    function royal_event_get_list_revo_sliders($prepend_inherit=false) {
        if (($list = royal_event_storage_get('list_revo_sliders'))=='') {
            $list = array();
            if (royal_event_exists_revslider()) {
                global $wpdb;
                // Attention! The use of wpdb->prepare() is not required
                // because the query does not use external data substitution
                $rows = $wpdb->get_results( "SELECT alias, title FROM " . esc_sql($wpdb->prefix) . "revslider_sliders" );
                if (is_array($rows) && count($rows) > 0) {
                    foreach ($rows as $row) {
                        $list[$row->alias] = $row->title;
                    }
                }
            }
            $list = apply_filters('royal_event_filter_list_revo_sliders', $list);
            if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_revo_sliders', $list);
        }
        return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
    }
}

// Add RevSlider in the Theme Options params
if ( !function_exists( 'royal_event_revslider_theme_options_params' ) ) {
    //Handler of add_filter( 'royal_event_filter_theme_options_params',			'royal_event_revslider_theme_options_params' );
    function royal_event_revslider_theme_options_params($list=array()) {
        $list["list_revo_sliders"] = array('$royal_event_get_list_revo_sliders' => '');
        return $list;
    }
}
?>