<?php
/* Instagram Widget support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_instagram_widget_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_instagram_widget_theme_setup', 1 );
	function royal_event_instagram_widget_theme_setup() {
		if (royal_event_exists_instagram_widget()) {
			add_action( 'royal_event_action_add_styles', 						'royal_event_instagram_widget_frontend_scripts' );
		}
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',					'royal_event_instagram_widget_required_plugins' );
		}
	}
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'royal_event_exists_instagram_widget' ) ) {
	function royal_event_exists_instagram_widget() {
		return function_exists('wpiw_init');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_instagram_widget_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_instagram_widget_required_plugins');
	function royal_event_instagram_widget_required_plugins($list=array()) {
		if (in_array('instagram_widget', royal_event_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Instagram Widget', 'royal-event'),
					'slug' 		=> 'wp-instagram-widget',
					'required' 	=> false
				);
		return $list;
	}
}

// Enqueue custom styles
if ( !function_exists( 'royal_event_instagram_widget_frontend_scripts' ) ) {
	//Handler of add_action( 'royal_event_action_add_styles', 'royal_event_instagram_widget_frontend_scripts' );
	function royal_event_instagram_widget_frontend_scripts() {
		if (file_exists(royal_event_get_file_dir('css/plugin.instagram-widget.css')))
			wp_enqueue_style( 'royal-event-plugin-instagram-widget-style',  royal_event_get_file_url('css/plugin.instagram-widget.css'), array(), null );
	}
}
?>