<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_instagram_feed_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_instagram_feed_theme_setup', 1 );
	function royal_event_instagram_feed_theme_setup() {
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',					'royal_event_instagram_feed_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'royal_event_exists_instagram_feed' ) ) {
	function royal_event_exists_instagram_feed() {
		return defined('SBIVER');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_instagram_feed_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_instagram_feed_required_plugins');
	function royal_event_instagram_feed_required_plugins($list=array()) {
		if (in_array('instagram_feed', royal_event_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Instagram Feed', 'royal-event'),
					'slug' 		=> 'instagram-feed',
					'required' 	=> false
				);
		return $list;
	}
}
?>