<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_gutenberg_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_gutenberg_theme_setup', 1 );
    function royal_event_gutenberg_theme_setup() {
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins', 'royal_event_gutenberg_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'royal_event_exists_gutenberg' ) ) {
    function royal_event_exists_gutenberg() {
        return function_exists( 'the_gutenberg_project' ) && function_exists( 'register_block_type' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_gutenberg_required_plugins' ) ) {
    function royal_event_gutenberg_required_plugins($list=array()) {
        if (in_array('gutenberg', (array)royal_event_storage_get('required_plugins')))
            $list[] = array(
                    'name'         => esc_html__('Gutenberg', 'royal-event'),
                    'slug'         => 'gutenberg',
                    'required'     => false
                );
        return $list;
    }
}