<?php
/* The GDPR compliance support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_gdpr_compliance_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_gdpr_compliance_theme_setup', 1 );
    function royal_event_gdpr_compliance_theme_setup() {
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins', 'royal_event_gdpr_compliance_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'royal_event_exists_gdpr_compliance' ) ) {
    function royal_event_exists_gdpr_compliance() {
        return defined( 'WP_GDPR_C_SLUG' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_gdpr_compliance_required_plugins' ) ) {
    function royal_event_gdpr_compliance_required_plugins($list=array()) {
        if (in_array('gdpr_compliance', (array)royal_event_storage_get('required_plugins')))
            $list[] = array(
                    'name'         => esc_html__('WP GDPR Compliance', 'royal-event'),
                    'slug'         => 'wp-gdpr-compliance',
                    'required'     => false
                );
        return $list;
    }
}