<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_essgrids_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_essgrids_theme_setup', 1 );
    function royal_event_essgrids_theme_setup() {
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins',				'royal_event_essgrids_required_plugins' );
        }
    }
}


// Check if Ess. Grid installed and activated
if ( !function_exists( 'royal_event_exists_essgrids' ) ) {
    function royal_event_exists_essgrids() {
        return defined('EG_PLUGIN_PATH') || defined('ESG_PLUGIN_PATH');
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_essgrids_required_plugins' ) ) {
    //Handler of add_filter('royal_event_filter_required_plugins',	'royal_event_essgrids_required_plugins');
    function royal_event_essgrids_required_plugins($list=array()) {
        if (in_array('essgrids', royal_event_storage_get('required_plugins'))) {
            $path = royal_event_get_file_dir('plugins/install/essential-grid.zip');
            if (file_exists($path)) {
                $list[] = array(
                    'name' 		=> esc_html__('Essential Grid', 'royal-event'),
                    'slug' 		=> 'essential-grid',
                    'version'   => '3.0.16',
                    'source'	=> $path,
                    'required' 	=> false
                );
            }
        }
        return $list;
    }
}
?>