<?php
/* Elementor Builder support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'royal_event_elm_theme_setup9' ) ) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_elm_theme_setup9', 1 );
	function royal_event_elm_theme_setup9() {
	if ( royal_event_exists_elementor() ) {

		add_action( 'init', 'royal_event_elm_init_once', 3 );

		add_action( 'elementor/editor/before_enqueue_scripts', 'royal_event_elm_editor_scripts' );
		add_action( 'elementor/element/before_section_end', 'royal_event_elm_add_color_scheme_control', 10, 3 );


		add_filter( 'royal_event_filter_merge_styles', 'royal_event_elm_merge_styles' );
		add_filter( 'royal_event_filter_merge_styles_responsive', 'royal_event_elm_merge_styles_responsive' );
	}
		if ( is_admin() ) {
			add_filter( 'royal_event_filter_required_plugins', 'royal_event_elm_tgmpa_required_plugins' );
		
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'royal_event_elm_tgmpa_required_plugins' ) ) {
	function royal_event_elm_tgmpa_required_plugins( $list = array() ) {
        if (in_array('elementor', (array)royal_event_storage_get('required_plugins')))
			$list[] = array(
				'name'     => esc_html__('Elementor', 'royal-event'),
				'slug'     => 'elementor',
				'required' => false,
			);
        return $list;
		}
}

// Check if Elementor is installed and activated
if ( ! function_exists( 'royal_event_exists_elementor' ) ) {
	function royal_event_exists_elementor() {
		return class_exists( 'Elementor\Plugin' );
	}
}


// Enqueue responsive styles for frontend
if ( ! function_exists( 'royal_event_elm_responsive_styles' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'royal_event_elm_responsive_styles', 2000 );
	function royal_event_elm_responsive_styles() {
		$royal_event_url = royal_event_get_file_url( 'plugins/elementor/elementor-responsive.css' );
		if ( '' != $royal_event_url ) {
			wp_enqueue_style( 'royal-event-elementor-responsive', $royal_event_url, array(), null );
		}
	}
}

// Load required styles and scripts for Elementor Editor mode
if ( ! function_exists( 'royal_event_elm_editor_scripts' ) ) {
	function royal_event_elm_editor_scripts() {
		wp_enqueue_style( 'fontello-style', royal_event_get_file_url( 'css/font-icons/css/fontello.css' ), array(), null );
	}
}


// Add theme-specific controls to sections and columns
if ( ! function_exists( 'royal_event_elm_add_color_scheme_control' ) ) {
	//Handler of the add_action( 'elementor/element/before_section_end', 'royal_event_elm_add_color_scheme_control', 10, 3 );
	function royal_event_elm_add_color_scheme_control( $element, $section_id, $args ) {
		if ( is_object( $element ) ) {
			$el_name = $element->get_name();
			// Add color scheme selector
			if ( apply_filters(
				'royal_event_filter_add_scheme_in_elements',
				( in_array( $el_name, array( 'section', 'column' ) ) && 'section_advanced' === $section_id )
							|| ( 'common' === $el_name && '_section_style' === $section_id ),
				$element, $section_id, $args
			) ) {
				$element->add_control(
					'scheme', array(
						'type'         => \Elementor\Controls_Manager::SELECT,
						'label'        => esc_html__( 'Color scheme', 'royal-event' ),
						'label_block'  => true,
						'options'      => royal_event_array_merge( array( '' => esc_html__( 'Inherit', 'royal-event' ) ), royal_event_get_list_schemes() ),
						'default'      => '',
						'prefix_class' => 'scheme_',
					)
				);
			}
		}
	}
}

// Set Elementor's options at once
if ( ! function_exists( 'royal_event_elm_init_once' ) ) {
	//Handler of the add_action( 'init', 'royal_event_elm_init_once', 3 );
	function royal_event_elm_init_once() {
		if ( royal_event_exists_elementor() && ! get_option( 'royal_event_setup_elementor_options', false ) ) {
			// Set theme-specific values to the Elementor's options
			// Disable DOM optimization for Elementor 3.0+
			update_option( 'elementor_optimized_dom_output', 'disabled' );
			update_option( 'elementor_disable_color_schemes', 'yes' );
			update_option( 'elementor_disable_typography_schemes', 'yes' );
			update_option( 'elementor_space_between_widgets', 0 );
			update_option( 'elementor_stretched_section_container', '.page_wrap' );
			update_option( 'elementor_page_title_selector', '.sc_layouts_title_caption' );
			// Set flag to prevent change Elementor's options again
			update_option( 'royal_event_setup_elementor_options', 1 );
		}
	}
}


?>