<?php
/* elegro Crypto Payment support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_woocommerce_elegro_payment_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_woocommerce_elegro_payment_theme_setup', 1 );
    function royal_event_woocommerce_elegro_payment_theme_setup() {
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins', 'royal_event_woocommerce_elegro_payment_required_plugins' );
        }
    }
}

// Check if elegro Crypto Payment installed and activated
if ( !function_exists( 'royal_event_exists_woocommerce_elegro_payment' ) ) {
    function royal_event_exists_woocommerce_elegro_payment() {
        return function_exists('init_Elegro_Payment');
    }
}


// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_woocommerce_elegro_payment_required_plugins' ) ) {
    function royal_event_woocommerce_elegro_payment_required_plugins($list=array()) {
        if (in_array('elegro-payment', (array)royal_event_storage_get('required_plugins')))
            $list[] = array(
                'name' 		=> esc_html__('elegro Crypto Payment', 'royal-event'),
                'slug' 		=> 'elegro-payment',
                'required' 	=> false
            );
        return $list;
    }
}
