<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_contact_form_7_theme_setup')) {
    add_action( 'royal_event_action_before_init_theme', 'royal_event_contact_form_7_theme_setup', 1 );
    function royal_event_contact_form_7_theme_setup() {
        if (is_admin()) {
            add_filter( 'royal_event_filter_required_plugins', 'royal_event_contact_form_7_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'royal_event_exists_contact_form_7' ) ) {
    function royal_event_exists_contact_form_7() {
        return defined( 'Contact Form 7' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_contact_form_7_required_plugins' ) ) {
    function royal_event_contact_form_7_required_plugins($list=array()) {
        if (in_array('contact-form-7', (array)royal_event_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Contact Form 7', 'royal-event'),
                'slug'         => 'contact-form-7',
                'required'     => false
            );
        return $list;
    }
}
