<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('royal_event_booked_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_booked_theme_setup', 1 );
	function royal_event_booked_theme_setup() {
		// Register shortcode in the shortcodes list
		if (royal_event_exists_booked()) {
			add_action('royal_event_action_add_styles', 					'royal_event_booked_frontend_scripts');
		}
		if (is_admin()) {
			add_filter( 'royal_event_filter_required_plugins',				'royal_event_booked_required_plugins' );
		}
	}
}


// Check if plugin installed and activated
if ( !function_exists( 'royal_event_exists_booked' ) ) {
	function royal_event_exists_booked() {
		return class_exists('booked_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'royal_event_booked_required_plugins' ) ) {
	//Handler of add_filter('royal_event_filter_required_plugins',    'royal_event_booked_required_plugins');
	function royal_event_booked_required_plugins($list=array()) {
		if (in_array('booked', (array)royal_event_storage_get('required_plugins'))) {
			$path = royal_event_get_file_dir('plugins/install/booked.zip');
			if (!empty($path) && file_exists($path)) {
				$list[] = array(
					'name'         => esc_html__('Booked', 'royal-event'),
					'slug'         => 'booked',
                    'version'      => '2.4',
					'source'       => $path,
					'required'     => false
				);
			}
		}
		return $list;
	}
}

// Enqueue custom styles
if ( !function_exists( 'royal_event_booked_frontend_scripts' ) ) {
	//Handler of add_action( 'royal_event_action_add_styles', 'royal_event_booked_frontend_scripts' );
	function royal_event_booked_frontend_scripts() {
		if (file_exists(royal_event_get_file_dir('css/plugin.booked.css')))
			wp_enqueue_style( 'royal-event-plugin-booked-style',  royal_event_get_file_url('css/plugin.booked.css'), array(), null );
	}
}


// Lists
//------------------------------------------------------------------------

// Return booked calendars list, prepended inherit (if need)
if ( !function_exists( 'royal_event_get_list_booked_calendars' ) ) {
	function royal_event_get_list_booked_calendars($prepend_inherit=false) {
		return royal_event_exists_booked() ? royal_event_get_list_terms($prepend_inherit, 'booked_custom_calendars') : array();
	}
}
?>