<?php
/**
 * Theme custom styles
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }


/* Theme setup section
-------------------------------------------------------------------- */

if (!function_exists('royal_event_action_theme_styles_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_action_theme_styles_theme_setup', 1 );
	function royal_event_action_theme_styles_theme_setup() {
	
		// Add theme fonts in the used fonts list
		add_filter('royal_event_filter_used_fonts',			'royal_event_filter_theme_styles_used_fonts');
		// Add theme fonts (from Google fonts) in the main fonts list (if not present).
		add_filter('royal_event_filter_list_fonts',			'royal_event_filter_theme_styles_list_fonts');

		// Add theme stylesheets
		add_action('royal_event_action_add_styles',			'royal_event_action_theme_styles_add_styles');
		// Add theme inline styles
		add_filter('royal_event_filter_add_styles_inline',		'royal_event_filter_theme_styles_add_styles_inline');

		// Add theme scripts
		add_action('royal_event_action_add_scripts',			'royal_event_action_theme_styles_add_scripts');
		// Add theme scripts inline
		add_filter('royal_event_filter_localize_script',		'royal_event_filter_theme_styles_localize_script');

		// Add theme less files into list for compilation
		add_filter('royal_event_filter_compile_less',			'royal_event_filter_theme_styles_compile_less');

		// Add color schemes
		royal_event_add_color_scheme('original', array(

			'title'					=> esc_html__('Original', 'royal-event'),
			
			// Whole block border and background
			'bd_color'				=> '#f3f1ec',
			'bg_color'				=> '#ffffff',
			
			// Headers, text and links colors
			'text'					=> '#929292',
			'text_light'			=> '#eae7e0',
			'text_dark'				=> '#434343',
			'text_link'				=> '#ffb18b',
			'text_hover'			=> '#efa27d',

			// Inverse colors
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#ffffff',
		
			// Input fields
			'input_text'			=> '#808369',
			'input_light'			=> '#808369',
			'input_dark'			=> '#808369',
			'input_bd_color'		=> '#ebebe7',
			'input_bd_hover'		=> '#a7a99a',
			'input_bg_color'		=> '#ffffff',
			'input_bg_hover'		=> '#ffffff',

			// Alternative blocks (submenu items, etc.)
			'alter_text'			=> '#808369',
			'alter_light'			=> '#332829',
			'alter_dark'			=> '#434343',
			'alter_link'			=> '#808369',
			'alter_hover'			=> '#434343',
			'alter_bd_color'		=> '#a7a99a',
			'alter_bd_hover'		=> '#bbbbbb',
			'alter_bg_color'		=> '#f3f1ec',
			'alter_bg_hover'		=> '#a7a99a',
			)
		);

		// Add color schemes
		royal_event_add_color_scheme('scheme_2', array(

			'title'					=> esc_html__('Scheme 2', 'royal-event'),

			// Whole block border and background
			'bd_color'				=> '#f3f1ec',
			'bg_color'				=> '#ffffff',

			// Headers, text and links colors
			'text'					=> '#929292',
			'text_light'			=> '#eae7e0',
			'text_dark'				=> '#434343',
			'text_link'				=> '#77c4d3',
			'text_hover'			=> '#efa27d',

			// Inverse colors
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#ffffff',

			// Input fields
			'input_text'			=> '#808369',
			'input_light'			=> '#808369',
			'input_dark'			=> '#808369',
			'input_bd_color'		=> '#ebebe7',
			'input_bd_hover'		=> '#a7a99a',
			'input_bg_color'		=> '#ffffff',
			'input_bg_hover'		=> '#ffffff',

			// Alternative blocks (submenu items, etc.)
			'alter_text'			=> '#808369',
			'alter_light'			=> '#332829',
			'alter_dark'			=> '#434343',
			'alter_link'			=> '#808369',
			'alter_hover'			=> '#434343',
			'alter_bd_color'		=> '#a7a99a',
			'alter_bd_hover'		=> '#bbbbbb',
			'alter_bg_color'		=> '#f3f1ec',
			'alter_bg_hover'		=> '#a7a99a',
			)
		);

		// Add color schemes
		royal_event_add_color_scheme('scheme_3', array(

			'title'					=> esc_html__('Scheme 3', 'royal-event'),

			// Whole block border and background
			'bd_color'				=> '#f3f1ec',
			'bg_color'				=> '#ffffff',

			// Headers, text and links colors
			'text'					=> '#929292',
			'text_light'			=> '#eae7e0',
			'text_dark'				=> '#434343',
			'text_link'				=> '#79bd8f',
			'text_hover'			=> '#efa27d',

			// Inverse colors
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#ffffff',

			// Input fields
			'input_text'			=> '#808369',
			'input_light'			=> '#808369',
			'input_dark'			=> '#808369',
			'input_bd_color'		=> '#ebebe7',
			'input_bd_hover'		=> '#a7a99a',
			'input_bg_color'		=> '#ffffff',
			'input_bg_hover'		=> '#ffffff',

			// Alternative blocks (submenu items, etc.)
			'alter_text'			=> '#808369',
			'alter_light'			=> '#332829',
			'alter_dark'			=> '#434343',
			'alter_link'			=> '#808369',
			'alter_hover'			=> '#434343',
			'alter_bd_color'		=> '#a7a99a',
			'alter_bd_hover'		=> '#bbbbbb',
			'alter_bg_color'		=> '#f3f1ec',
			'alter_bg_hover'		=> '#a7a99a',
			)
		);

		// Add color schemes
		royal_event_add_color_scheme('scheme_4', array(

			'title'					=> esc_html__('Scheme 4', 'royal-event'),

			// Whole block border and background
			'bd_color'				=> '#f3f1ec',
			'bg_color'				=> '#ffffff',

			// Headers, text and links colors
			'text'					=> '#929292',
			'text_light'			=> '#eae7e0',
			'text_dark'				=> '#434343',
			'text_link'				=> '#f54f29',
			'text_hover'			=> '#efa27d',

			// Inverse colors
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#ffffff',
			'inverse_hover'			=> '#ffffff',

			// Input fields
			'input_text'			=> '#808369',
			'input_light'			=> '#808369',
			'input_dark'			=> '#808369',
			'input_bd_color'		=> '#ebebe7',
			'input_bd_hover'		=> '#a7a99a',
			'input_bg_color'		=> '#ffffff',
			'input_bg_hover'		=> '#ffffff',

			// Alternative blocks (submenu items, etc.)
			'alter_text'			=> '#808369',
			'alter_light'			=> '#332829',
			'alter_dark'			=> '#434343',
			'alter_link'			=> '#808369',
			'alter_hover'			=> '#434343',
			'alter_bd_color'		=> '#a7a99a',
			'alter_bd_hover'		=> '#bbbbbb',
			'alter_bg_color'		=> '#f3f1ec',
			'alter_bg_hover'		=> '#a7a99a',
			)
		);

        // Add Custom fonts
        royal_event_add_custom_font('p', array(
                'title'			=> esc_html__('Text', 'royal-event'),
                'description'	=> '',
                'font-family'	=> 'PT Serif',
                'font-size' 	=> '14px',
                'font-weight'	=> '400',
                'font-style'	=> '',
                'line-height'	=> '1.75em',
                'margin-top'	=> '',
                'margin-bottom'	=> '1em'
            )
        );
        royal_event_add_custom_font('h1', array(
                'title'			=> esc_html__('Heading 1', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '4.286rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.2em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '0.8em'
            )
        );
        royal_event_add_custom_font('h2', array(
                'title'			=> esc_html__('Heading 2', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '3.571rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.2em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '0.7em'
            )
        );
        royal_event_add_custom_font('h3', array(
                'title'			=> esc_html__('Heading 3', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '2.5rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.2em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '1.05em'
            )
        );
        royal_event_add_custom_font('h4', array(
                'title'			=> esc_html__('Heading 4', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '1.571rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.5em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '1.35em'
            )
        );
        royal_event_add_custom_font('h5', array(
                'title'			=> esc_html__('Heading 5', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '1.286rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.3em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '1.05em'
            )
        );
        royal_event_add_custom_font('h6', array(
                'title'			=> esc_html__('Heading 6', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '1rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.8em',
                'margin-top'	=> '0',
                'margin-bottom'	=> '0.7em'
            )
        );
        royal_event_add_custom_font('logo', array(
                'title'			=> esc_html__('Logo', 'royal-event'),
                'description'	=> '',
                'font-family'	=> 'Yellowtail',
                'font-size' 	=> '3.214rem',
                'font-weight'	=> '400',
                'font-style'	=> '',
                'line-height'	=> '1.1em'
            )
        );
        royal_event_add_custom_font('menu', array(
                'title'			=> esc_html__('Main menu items', 'royal-event'),
                'description'	=> '',
                'font-family'	=> 'PT Serif',
                'font-size' 	=> '1rem',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '0.8em'
            )
        );
        royal_event_add_custom_font('submenu', array(
                'title'			=> esc_html__('Dropdown menu items', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '',
                'font-weight'	=> '700',
                'font-style'	=> '',
                'line-height'	=> '1.3em'
            )
        );
        royal_event_add_custom_font('button', array(
                'title'			=> esc_html__('Buttons', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> '1rem',
                'font-weight'	=> '700',
                'line-height'	=> '1.75em',
                'font-style'	=> ''
            )
        );
        royal_event_add_custom_font('input', array(
                'title'			=> esc_html__('Input fields', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> ''
            )
        );
        royal_event_add_custom_font('info', array(
                'title'			=> esc_html__('Post info', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> ''
            )
        );
        royal_event_add_custom_font('link', array(
                'title'			=> esc_html__('Links', 'royal-event'),
                'description'	=> '',
                'font-family'	=> '',
                'font-size' 	=> ''
            )
        );
        
	}
}





//------------------------------------------------------------------------------
// Theme fonts
//------------------------------------------------------------------------------

// Add theme fonts in the used fonts list
if (!function_exists('royal_event_filter_theme_styles_used_fonts')) {
	function royal_event_filter_theme_styles_used_fonts($theme_fonts) {
		$theme_fonts['Lato'] = 1;
		return $theme_fonts;
	}
}

// Add theme fonts (from Google fonts) in the main fonts list (if not present).
if (!function_exists('royal_event_filter_theme_styles_list_fonts')) {
	function royal_event_filter_theme_styles_list_fonts($list) {
		if (!isset($list['Lato']))	$list['Lato'] = array('family'=>'sans-serif');
		return $list;
	}
}



//------------------------------------------------------------------------------
// Theme stylesheets
//------------------------------------------------------------------------------

// Add theme.less into list files for compilation
if (!function_exists('royal_event_filter_theme_styles_compile_less')) {
	function royal_event_filter_theme_styles_compile_less($files) {
		if (file_exists(royal_event_get_file_dir('css/theme.less'))) {
		 	$files[] = royal_event_get_file_dir('css/theme.less');
		}
		return $files;	
	}
}

// Add theme stylesheets
if (!function_exists('royal_event_action_theme_styles_add_styles')) {
	function royal_event_action_theme_styles_add_styles() {
		// Add stylesheet files only if LESS supported
		if ( royal_event_get_theme_setting('less_compiler') != 'no' ) {
			wp_enqueue_style( 'royal-event-theme-style', royal_event_get_file_url('css/theme.css'), array(), null );
			wp_add_inline_style( 'royal-event-theme-style', royal_event_get_inline_css() );
		}
	}
}

// Add theme inline styles
if (!function_exists('royal_event_filter_theme_styles_add_styles_inline')) {
	function royal_event_filter_theme_styles_add_styles_inline($custom_style) {
		// Todo: add theme specific styles in the $custom_style to override
		//       rules from style.css and shortcodes.css

        // Mobile menu
        $menu_mobile = royal_event_get_theme_option('menu_mobile');
        if (!empty($menu_mobile)) {
            $custom_style .= "
				@media (max-width: ".intval($menu_mobile)."px) {
					header.top_panel_wrap{
						display: none;
					}
				
					.header_mobile{
						display: block;
					}
				}";
        }

        // Submenu width
		$menu_width = royal_event_get_theme_option('menu_width');
		if (!empty($menu_width)) {
			$custom_style .= "
				/* Submenu width */
				.menu_side_nav > li ul,
				.menu_main_nav > li ul {
					width: ".intval($menu_width)."px;
				}
				.menu_side_nav > li > ul ul,
				.menu_main_nav > li > ul ul {
					left:".intval($menu_width+4)."px;
				}
				.menu_side_nav > li > ul ul.submenu_left,
				.menu_main_nav > li > ul ul.submenu_left {
					left:-".intval($menu_width+1)."px;
				}
			";
		}
	
		// Logo height
		$logo_height = royal_event_get_custom_option('logo_height');
		if (!empty($logo_height)) {
			$custom_style .= "
				/* Logo header height */
				.sidebar_outer_logo .logo_main,
				.top_panel_wrap .logo_main,
				.top_panel_wrap .logo_fixed,
				.widget_socials .logo img {
					height:".intval($logo_height)."px;
				}
			";
		}
	
		// Logo top offset
		$logo_offset = royal_event_get_custom_option('logo_offset');
		if (!empty($logo_offset)) {
			$custom_style .= "
				/* Logo header top offset */
				.top_panel_wrap .logo {
					margin-top:".intval($logo_offset)."px;
				}
			";
		}

		// Logo footer height
		$logo_height = royal_event_get_theme_option('logo_footer_height');
		if (!empty($logo_height)) {
			$custom_style .= "
				/* Logo footer height */
				.contacts_wrap .logo img {
					height:".intval($logo_height)."px;
				}
			";
		}

        // Special image
        $special_image_1 = royal_event_get_theme_option('special_image_1');
        if (!empty($special_image_1)) {
            $custom_style .= "
				/* Special image 1 */
                blockquote,
                .vc_row:not(.with-custom-background) .sc_price_block,
                .sc_audio.sc_audio_player,
                .sidebar_inner.widget_area_inner,
                .isotope_wrap .isotope_item_masonry.isotope_item .post_item .post_content{
                    background-image: url(".($special_image_1).");
                    background-repeat: repeat;
                }
			";
        }
        $special_image_2 = royal_event_get_theme_option('special_image_2');
        if (!empty($special_image_2)) {
            $custom_style .= "
				/* Special image 2 */
                .title_bg{
                    background-image: url(".($special_image_2).");
                }
			";
        }
        $special_image_3 = royal_event_get_theme_option('special_image_3');
        if (!empty($special_image_3)) {
            $custom_style .= "
				/* Special image 3 */
                .inverse_colors .title_bg,
                .sc_intro_inner .title_bg{
                    background-image: url(".($special_image_3).");
                }
			";
        }

        $body_style  = royal_event_get_custom_option('body_style');
        $style = '';
        if (royal_event_get_custom_option('bg_custom')=='yes' && ($body_style=='boxed' || royal_event_get_custom_option('bg_image_load')=='always')) {
            if (($img = royal_event_get_custom_option('bg_image_custom')) != '')
                $style = 'background: url('.esc_url($img).') ' . str_replace('_', ' ', royal_event_get_custom_option('bg_image_custom_position')) . ' no-repeat fixed;';
            else if (($img = royal_event_get_custom_option('bg_pattern_custom')) != '')
                $style = 'background: url('.esc_url($img).') 0 0 repeat fixed;';
            if (($img = royal_event_get_custom_option('bg_color')) != '')
                $style .= 'background-color: '.($img).';';

            $custom_style .= "
				/* body_wrap */
                html body.body_style_boxed .body_wrap{
                    ".($style)."
                }
			";
        }


        // Get custom image
        $header_image = '';
        if (empty($header_image))
            $header_image = royal_event_get_custom_option('top_panel_title_image');
        if (empty($header_image))
            $header_image = get_header_image();
        if (!empty($header_image)) {
            $header_image = 'background-image: url('.esc_url($header_image).');';
        }
        if($header_image!='') {
            $custom_style .= "
                .top_panel_title_inner.with_image{
                    " . ($header_image) . "
                }
            ";
        }

		// Custom css from theme options
		$custom_style .= royal_event_get_custom_option('custom_css');

		return $custom_style;	
	}
}


//------------------------------------------------------------------------------
// Theme scripts
//------------------------------------------------------------------------------

// Add theme scripts
if (!function_exists('royal_event_action_theme_styles_add_scripts')) {
	function royal_event_action_theme_styles_add_scripts() {
		if (royal_event_get_theme_option('show_theme_customizer') == 'yes' && file_exists(royal_event_get_file_dir('js/theme.customizer.js')))
			wp_enqueue_script( 'royal-event-theme-styles-customizer-script', royal_event_get_file_url('js/theme.customizer.js'), array(), null, true );
	}
}

// Add theme scripts inline
if (!function_exists('royal_event_filter_theme_styles_localize_script')) {
	function royal_event_filter_theme_styles_localize_script($vars) {
		if (empty($vars['theme_font']))
			$vars['theme_font'] = royal_event_get_custom_font_settings('p', 'font-family');
		$vars['theme_color'] = royal_event_get_scheme_color('text_dark');
		$vars['theme_bg_color'] = royal_event_get_scheme_color('bg_color');
		return $vars;
	}
}
?>