<?php
/**
 * Royal Event Framework: strings manipulations
 *
 * @package	royal_event
 * @since	royal_event 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Check multibyte functions
if ( ! defined( 'ROYAL_EVENT_MULTIBYTE' ) ) define( 'ROYAL_EVENT_MULTIBYTE', function_exists('mb_strpos') ? 'UTF-8' : false );

if (!function_exists('royal_event_strlen')) {
	function royal_event_strlen($text) {
		return ROYAL_EVENT_MULTIBYTE ? mb_strlen($text) : strlen($text);
	}
}

if (!function_exists('royal_event_strpos')) {
	function royal_event_strpos($text, $char, $from=0) {
		return ROYAL_EVENT_MULTIBYTE ? mb_strpos($text, $char, $from) : strpos($text, $char, $from);
	}
}

if (!function_exists('royal_event_strrpos')) {
	function royal_event_strrpos($text, $char, $from=0) {
		return ROYAL_EVENT_MULTIBYTE ? mb_strrpos($text, $char, $from) : strrpos($text, $char, $from);
	}
}

if (!function_exists('royal_event_substr')) {
	function royal_event_substr($text, $from, $len=-999999) {
		if ($len==-999999) { 
			if ($from < 0)
				$len = -$from; 
			else
				$len = royal_event_strlen($text)-$from;
		}
		return ROYAL_EVENT_MULTIBYTE ? mb_substr($text, $from, $len) : substr($text, $from, $len);
	}
}

if (!function_exists('royal_event_strtolower')) {
	function royal_event_strtolower($text) {
		return ROYAL_EVENT_MULTIBYTE ? mb_strtolower($text) : strtolower($text);
	}
}

if (!function_exists('royal_event_strtoupper')) {
	function royal_event_strtoupper($text) {
		return ROYAL_EVENT_MULTIBYTE ? mb_strtoupper($text) : strtoupper($text);
	}
}

if (!function_exists('royal_event_strtoproper')) {
	function royal_event_strtoproper($text) { 
		$rez = ''; $last = ' ';
		for ($i=0; $i<royal_event_strlen($text); $i++) {
			$ch = royal_event_substr($text, $i, 1);
			$rez .= royal_event_strpos(' .,:;?!()[]{}+=', $last)!==false ? royal_event_strtoupper($ch) : royal_event_strtolower($ch);
			$last = $ch;
		}
		return $rez;
	}
}

if (!function_exists('royal_event_strrepeat')) {
	function royal_event_strrepeat($str, $n) {
		$rez = '';
		for ($i=0; $i<$n; $i++)
			$rez .= $str;
		return $rez;
	}
}

if (!function_exists('royal_event_strshort')) {
	function royal_event_strshort($str, $maxlength, $add='...') {
		if ($maxlength < 0) 
			return $str;
		if ($maxlength == 0) 
			return '';
		if ($maxlength >= royal_event_strlen($str)) 
			return strip_tags($str);
		$str = royal_event_substr(strip_tags($str), 0, $maxlength - royal_event_strlen($add));
		$ch = royal_event_substr($str, $maxlength - royal_event_strlen($add), 1);
		if ($ch != ' ') {
			for ($i = royal_event_strlen($str) - 1; $i > 0; $i--)
				if (royal_event_substr($str, $i, 1) == ' ') break;
			$str = trim(royal_event_substr($str, 0, $i));
		}
		if (!empty($str) && royal_event_strpos(',.:;-', royal_event_substr($str, -1))!==false) $str = royal_event_substr($str, 0, -1);
		return ($str) . ($add);
	}
}

// Clear string from spaces, line breaks and tags (only around text)
if (!function_exists('royal_event_strclear')) {
	function royal_event_strclear($text, $tags=array()) {
		if (empty($text)) return $text;
		if (!is_array($tags)) {
			if ($tags != '')
				$tags = explode($tags, ',');
			else
				$tags = array();
		}
		$text = trim(chop($text));
		if (is_array($tags) && count($tags) > 0) {
			foreach ($tags as $tag) {
				$open  = '<'.esc_attr($tag);
				$close = '</'.esc_attr($tag).'>';
				if (royal_event_substr($text, 0, royal_event_strlen($open))==$open) {
					$pos = royal_event_strpos($text, '>');
					if ($pos!==false) $text = royal_event_substr($text, $pos+1);
				}
				if (royal_event_substr($text, -royal_event_strlen($close))==$close) $text = royal_event_substr($text, 0, royal_event_strlen($text) - royal_event_strlen($close));
				$text = trim(chop($text));
			}
		}
		return $text;
	}
}

// Return slug for the any title string
if (!function_exists('royal_event_get_slug')) {
	function royal_event_get_slug($title) {
		return royal_event_strtolower(str_replace(array('\\','/','-',' ','.'), '_', $title));
	}
}

// Replace macros in the string
if (!function_exists('royal_event_strmacros')) {
	function royal_event_strmacros($str) {
		return str_replace(array("{{", "}}", "((", "))", "||"), array("<i>", "</i>", "<b>", "</b>", "<br>"), $str);
	}
}

// Unserialize string
if (!function_exists('royal_event_unserialize')) {
    function royal_event_unserialize($str) {
        if ( !empty($str) && is_serialized($str) ) {
            // If serialized data content unrecoverable object (base class for this object is not exists) - skip this string
            if ( true || ! preg_match( '/O:[0-9]+:"([^"]*)":[0-9]+:{/', $str, $matches ) || empty( $matches[1] ) || class_exists( $matches[1] ) ) {
                try {
                    $data = unserialize($str);
                } catch (Exception $e) {
                    dcl($e->getMessage());
                    $data = false;
                }
                if ($data===false) {
                    try {
                        $str = preg_replace_callback (
                            '!s:(\d+):"(.*?)";!',
                            function( $match ) {
                                return ( $match[1] == strlen( $match[2] ) )
                                    ? $match[0]
                                    : 's:' . strlen( $match[2] ) . ':"' . $match[2] . '";';
                            },
                            $str
                        );
                        $data = unserialize($str);
                    } catch (Exception $e) {
                        dcl($e->getMessage());
                        $data = false;
                    }
                }
                return $data;
            } else {
                return $str;
            }
        } else {
            return $str;
        }
    }
}

?>