<?php
/**
 * Royal Event Framework: theme variables storage
 *
 * @package	royal_event
 * @since	royal_event 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('royal_event_storage_get')) {
	function royal_event_storage_get($var_name, $default='') {
		global $ROYAL_EVENT_STORAGE;
		return isset($ROYAL_EVENT_STORAGE[$var_name]) ? $ROYAL_EVENT_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('royal_event_storage_set')) {
	function royal_event_storage_set($var_name, $value) {
		global $ROYAL_EVENT_STORAGE;
		$ROYAL_EVENT_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('royal_event_storage_empty')) {
	function royal_event_storage_empty($var_name, $key='', $key2='') {
		global $ROYAL_EVENT_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($ROYAL_EVENT_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($ROYAL_EVENT_STORAGE[$var_name][$key]);
		else
			return empty($ROYAL_EVENT_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('royal_event_storage_isset')) {
	function royal_event_storage_isset($var_name, $key='', $key2='') {
		global $ROYAL_EVENT_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($ROYAL_EVENT_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($ROYAL_EVENT_STORAGE[$var_name][$key]);
		else
			return isset($ROYAL_EVENT_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('royal_event_storage_inc')) {
	function royal_event_storage_inc($var_name, $value=1) {
		global $ROYAL_EVENT_STORAGE;
		if (empty($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = 0;
		$ROYAL_EVENT_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('royal_event_storage_concat')) {
	function royal_event_storage_concat($var_name, $value) {
		global $ROYAL_EVENT_STORAGE;
		if (empty($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = '';
		$ROYAL_EVENT_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('royal_event_storage_get_array')) {
	function royal_event_storage_get_array($var_name, $key, $key2='', $default='') {
		global $ROYAL_EVENT_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($ROYAL_EVENT_STORAGE[$var_name][$key]) ? $ROYAL_EVENT_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($ROYAL_EVENT_STORAGE[$var_name][$key][$key2]) ? $ROYAL_EVENT_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('royal_event_storage_set_array')) {
	function royal_event_storage_set_array($var_name, $key, $value) {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if ($key==='')
			$ROYAL_EVENT_STORAGE[$var_name][] = $value;
		else
			$ROYAL_EVENT_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('royal_event_storage_set_array2')) {
	function royal_event_storage_set_array2($var_name, $key, $key2, $value) {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if (!isset($ROYAL_EVENT_STORAGE[$var_name][$key])) $ROYAL_EVENT_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$ROYAL_EVENT_STORAGE[$var_name][$key][] = $value;
		else
			$ROYAL_EVENT_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Add array element after the key
if (!function_exists('royal_event_storage_set_array_after')) {
	function royal_event_storage_set_array_after($var_name, $after, $key, $value='') {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if (is_array($key))
			royal_event_array_insert_after($ROYAL_EVENT_STORAGE[$var_name], $after, $key);
		else
			royal_event_array_insert_after($ROYAL_EVENT_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('royal_event_storage_set_array_before')) {
	function royal_event_storage_set_array_before($var_name, $before, $key, $value='') {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if (is_array($key))
			royal_event_array_insert_before($ROYAL_EVENT_STORAGE[$var_name], $before, $key);
		else
			royal_event_array_insert_before($ROYAL_EVENT_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('royal_event_storage_push_array')) {
	function royal_event_storage_push_array($var_name, $key, $value) {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($ROYAL_EVENT_STORAGE[$var_name], $value);
		else {
			if (!isset($ROYAL_EVENT_STORAGE[$var_name][$key])) $ROYAL_EVENT_STORAGE[$var_name][$key] = array();
			array_push($ROYAL_EVENT_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('royal_event_storage_pop_array')) {
	function royal_event_storage_pop_array($var_name, $key='', $defa='') {
		global $ROYAL_EVENT_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($ROYAL_EVENT_STORAGE[$var_name]) && is_array($ROYAL_EVENT_STORAGE[$var_name]) && count($ROYAL_EVENT_STORAGE[$var_name]) > 0) 
				$rez = array_pop($ROYAL_EVENT_STORAGE[$var_name]);
		} else {
			if (isset($ROYAL_EVENT_STORAGE[$var_name][$key]) && is_array($ROYAL_EVENT_STORAGE[$var_name][$key]) && count($ROYAL_EVENT_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($ROYAL_EVENT_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('royal_event_storage_inc_array')) {
	function royal_event_storage_inc_array($var_name, $key, $value=1) {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if (empty($ROYAL_EVENT_STORAGE[$var_name][$key])) $ROYAL_EVENT_STORAGE[$var_name][$key] = 0;
		$ROYAL_EVENT_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('royal_event_storage_concat_array')) {
	function royal_event_storage_concat_array($var_name, $key, $value) {
		global $ROYAL_EVENT_STORAGE;
		if (!isset($ROYAL_EVENT_STORAGE[$var_name])) $ROYAL_EVENT_STORAGE[$var_name] = array();
		if (empty($ROYAL_EVENT_STORAGE[$var_name][$key])) $ROYAL_EVENT_STORAGE[$var_name][$key] = '';
		$ROYAL_EVENT_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('royal_event_storage_call_obj_method')) {
	function royal_event_storage_call_obj_method($var_name, $method, $param=null) {
		global $ROYAL_EVENT_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($ROYAL_EVENT_STORAGE[$var_name]) ? $ROYAL_EVENT_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($ROYAL_EVENT_STORAGE[$var_name]) ? $ROYAL_EVENT_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('royal_event_storage_get_obj_property')) {
	function royal_event_storage_get_obj_property($var_name, $prop, $default='') {
		global $ROYAL_EVENT_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($ROYAL_EVENT_STORAGE[$var_name]->$prop) ? $ROYAL_EVENT_STORAGE[$var_name]->$prop : $default;
	}
}
?>