<?php
/**
 * Royal Event Framework: Theme options custom fields
 *
 * @package	royal_event
 * @since	royal_event 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }


/* Theme setup section
-------------------------------------------------------------------- */

if ( !function_exists( 'royal_event_options_custom_theme_setup' ) ) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_options_custom_theme_setup' );
	function royal_event_options_custom_theme_setup() {

		if ( is_admin() ) {
			add_action("admin_enqueue_scripts",	'royal_event_options_custom_load_scripts');
		}
		
	}
}

// Load required styles and scripts for custom options fields
if ( !function_exists( 'royal_event_options_custom_load_scripts' ) ) {
	//Handler of add_action("admin_enqueue_scripts", 'royal_event_options_custom_load_scripts');
	function royal_event_options_custom_load_scripts() {
		wp_enqueue_script( 'royal-event-options-custom-script',	royal_event_get_file_url('core/core.options/js/core.options-custom.js'), array(), null, true );
	}
}


// Show theme specific fields in Post (and Page) options
if ( !function_exists( 'royal_event_show_custom_field' ) ) {
	function royal_event_show_custom_field($id, $field, $value) {
		$output = '';
		switch ($field['type']) {
			case 'reviews':
				$output .= '<div class="reviews_block">' . trim(royal_event_reviews_get_markup($field, $value, true)) . '</div>';
				break;
	
			case 'mediamanager':
				wp_enqueue_media( );
				$output .= '<a id="'.esc_attr($id).'" class="button mediamanager royal_event_media_selector"
					data-param="' . esc_attr($id) . '"
					data-choose="'.esc_attr(isset($field['multiple']) && $field['multiple'] ? esc_html__( 'Choose Images', 'royal-event') : esc_html__( 'Choose Image', 'royal-event')).'"
					data-update="'.esc_attr(isset($field['multiple']) && $field['multiple'] ? esc_html__( 'Add to Gallery', 'royal-event') : esc_html__( 'Choose Image', 'royal-event')).'"
					data-multiple="'.esc_attr(isset($field['multiple']) && $field['multiple'] ? 'true' : 'false').'"
					data-linked-field="'.esc_attr($field['media_field_id']).'"
					>' . (isset($field['multiple']) && $field['multiple'] ? esc_html__( 'Choose Images', 'royal-event') : esc_html__( 'Choose Image', 'royal-event')) . '</a>';
				break;
		}
		return apply_filters('royal_event_filter_show_custom_field', $output, $id, $field, $value);
	}
}
?>