<?php
/**
 * Royal Event Framework: messages subsystem
 *
 * @package	royal_event
 * @since	royal_event 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Theme init
if (!function_exists('royal_event_messages_theme_setup')) {
	add_action( 'royal_event_action_before_init_theme', 'royal_event_messages_theme_setup' );
	function royal_event_messages_theme_setup() {
		// Core messages strings
		add_filter('royal_event_filter_localize_script', 'royal_event_messages_localize_script');
	}
}


/* Session messages
------------------------------------------------------------------------------------- */

if (!function_exists('royal_event_get_error_msg')) {
	function royal_event_get_error_msg() {
		return royal_event_storage_get('error_msg');
	}
}

if (!function_exists('royal_event_set_error_msg')) {
	function royal_event_set_error_msg($msg) {
		$msg2 = royal_event_get_error_msg();
		royal_event_storage_set('error_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}

if (!function_exists('royal_event_get_success_msg')) {
	function royal_event_get_success_msg() {
		return royal_event_storage_get('success_msg');
	}
}

if (!function_exists('royal_event_set_success_msg')) {
	function royal_event_set_success_msg($msg) {
		$msg2 = royal_event_get_success_msg();
		royal_event_storage_set('success_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}

if (!function_exists('royal_event_get_notice_msg')) {
	function royal_event_get_notice_msg() {
		return royal_event_storage_get('notice_msg');
	}
}

if (!function_exists('royal_event_set_notice_msg')) {
	function royal_event_set_notice_msg($msg) {
		$msg2 = royal_event_get_notice_msg();
		royal_event_storage_set('notice_msg', trim($msg2) . ($msg2=='' ? '' : '<br />') . trim($msg));
	}
}


/* System messages (save when page reload)
------------------------------------------------------------------------------------- */
if (!function_exists('royal_event_set_system_message')) {
	function royal_event_set_system_message($msg, $status='info', $hdr='') {
		update_option(royal_event_storage_get('options_prefix') . '_message', array('message' => $msg, 'status' => $status, 'header' => $hdr));
	}
}

if (!function_exists('royal_event_get_system_message')) {
	function royal_event_get_system_message($del=false) {
		$msg = get_option(royal_event_storage_get('options_prefix') . '_message', false);
		if (!$msg)
			$msg = array('message' => '', 'status' => '', 'header' => '');
		else if ($del)
			royal_event_del_system_message();
		return $msg;
	}
}

if (!function_exists('royal_event_del_system_message')) {
	function royal_event_del_system_message() {
		delete_option(royal_event_storage_get('options_prefix') . '_message');
	}
}


/* Messages strings
------------------------------------------------------------------------------------- */

if (!function_exists('royal_event_messages_localize_script')) {
	//Handler of add_filter('royal_event_filter_localize_script', 'royal_event_messages_localize_script');
	function royal_event_messages_localize_script($vars) {
		$vars['strings'] = array(
			'ajax_error'		=> esc_html__('Invalid server answer', 'royal-event'),
			'bookmark_add'		=> esc_html__('Add the bookmark', 'royal-event'),
            'bookmark_added'	=> esc_html__('Current page has been successfully added to the bookmarks. You can see it in the right panel on the tab \'Bookmarks\'', 'royal-event'),
            'bookmark_del'		=> esc_html__('Delete this bookmark', 'royal-event'),
            'bookmark_title'	=> esc_html__('Enter bookmark title', 'royal-event'),
            'bookmark_exists'	=> esc_html__('Current page already exists in the bookmarks list', 'royal-event'),
			'search_error'		=> esc_html__('Error occurs in AJAX search! Please, type your query and press search icon for the traditional search way.', 'royal-event'),
			'email_confirm'		=> esc_html__('On the e-mail address "%s" we sent a confirmation email. Please, open it and click on the link.', 'royal-event'),
			'reviews_vote'		=> esc_html__('Thanks for your vote! New average rating is:', 'royal-event'),
			'reviews_error'		=> esc_html__('Error saving your vote! Please, try again later.', 'royal-event'),
			'error_like'		=> esc_html__('Error saving your like! Please, try again later.', 'royal-event'),
			'error_global'		=> esc_html__('Global error text', 'royal-event'),
			'name_empty'		=> esc_html__('The name can\'t be empty', 'royal-event'),
			'name_long'			=> esc_html__('Too long name', 'royal-event'),
			'email_empty'		=> esc_html__('Too short (or empty) email address', 'royal-event'),
			'email_long'		=> esc_html__('Too long email address', 'royal-event'),
			'email_not_valid'	=> esc_html__('Invalid email address', 'royal-event'),
			'subject_empty'		=> esc_html__('The subject can\'t be empty', 'royal-event'),
			'subject_long'		=> esc_html__('Too long subject', 'royal-event'),
			'text_empty'		=> esc_html__('The message text can\'t be empty', 'royal-event'),
			'text_long'			=> esc_html__('Too long message text', 'royal-event'),
			'send_complete'		=> esc_html__("Send message complete!", 'royal-event'),
			'send_error'		=> esc_html__('Transmit failed!', 'royal-event'),
			'geocode_error'			=> esc_html__('Geocode was not successful for the following reason:', 'royal-event'),
			'googlemap_not_avail'	=> esc_html__('Google map API not available!', 'royal-event'),
			'editor_save_success'	=> esc_html__("Post content saved!", 'royal-event'),
			'editor_save_error'		=> esc_html__("Error saving post data!", 'royal-event'),
			'editor_delete_post'	=> esc_html__("You really want to delete the current post?", 'royal-event'),
			'editor_delete_post_header'	=> esc_html__("Delete post", 'royal-event'),
			'editor_delete_success'	=> esc_html__("Post deleted!", 'royal-event'),
			'editor_delete_error'	=> esc_html__("Error deleting post!", 'royal-event'),
			'editor_caption_cancel'	=> esc_html__('Cancel', 'royal-event'),
			'editor_caption_close'	=> esc_html__('Close', 'royal-event')
			);
		return $vars;
	}
}
?>