<?php
/**
 * Royal Event Framework: return lists
 *
 * @package royal_event
 * @since royal_event 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }



// Return styles list
if ( !function_exists( 'royal_event_get_list_styles' ) ) {
	function royal_event_get_list_styles($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = sprintf(esc_html__('Style %d', 'royal-event'), $i);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the shortcodes margins
if ( !function_exists( 'royal_event_get_list_margins' ) ) {
	function royal_event_get_list_margins($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_margins'))=='') {
			$list = array(
				'null'		=> esc_html__('0 (No margin)',	'royal-event'),
				'tiny'		=> esc_html__('Tiny',		'royal-event'),
				'small'		=> esc_html__('Small',		'royal-event'),
				'medium'	=> esc_html__('Medium',		'royal-event'),
				'large'		=> esc_html__('Large',		'royal-event'),
				'huge'		=> esc_html__('Huge',		'royal-event'),
				'tiny-'		=> esc_html__('Tiny (negative)',	'royal-event'),
				'small-'	=> esc_html__('Small (negative)',	'royal-event'),
				'medium-'	=> esc_html__('Medium (negative)',	'royal-event'),
				'large-'	=> esc_html__('Large (negative)',	'royal-event'),
				'huge-'		=> esc_html__('Huge (negative)',	'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_margins', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_margins', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the line styles
if ( !function_exists( 'royal_event_get_list_line_styles' ) ) {
	function royal_event_get_list_line_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_line_styles'))=='') {
			$list = array(
				'solid'	=> esc_html__('Solid', 'royal-event'),
				'dashed'=> esc_html__('Dashed', 'royal-event'),
				'dotted'=> esc_html__('Dotted', 'royal-event'),
				'double'=> esc_html__('Double', 'royal-event'),
				'image'	=> esc_html__('Image', 'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_line_styles', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_line_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the animations
if ( !function_exists( 'royal_event_get_list_animations' ) ) {
	function royal_event_get_list_animations($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_animations'))=='') {
			$list = array(
				'none'			=> esc_html__('- None -',	'royal-event'),
				'bounce'		=> esc_html__('Bounce',		'royal-event'),
				'elastic'		=> esc_html__('Elastic',	'royal-event'),
				'flash'			=> esc_html__('Flash',		'royal-event'),
				'flip'			=> esc_html__('Flip',		'royal-event'),
				'pulse'			=> esc_html__('Pulse',		'royal-event'),
				'rubberBand'	=> esc_html__('Rubber Band','royal-event'),
				'shake'			=> esc_html__('Shake',		'royal-event'),
				'swing'			=> esc_html__('Swing',		'royal-event'),
				'tada'			=> esc_html__('Tada',		'royal-event'),
				'wobble'		=> esc_html__('Wobble',		'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_animations', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_animations', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the enter animations
if ( !function_exists( 'royal_event_get_list_animations_in' ) ) {
	function royal_event_get_list_animations_in($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_animations_in'))=='') {
			$list = array(
				'none'				=> esc_html__('- None -',			'royal-event'),
				'bounceIn'			=> esc_html__('Bounce In',			'royal-event'),
				'bounceInUp'		=> esc_html__('Bounce In Up',		'royal-event'),
				'bounceInDown'		=> esc_html__('Bounce In Down',		'royal-event'),
				'bounceInLeft'		=> esc_html__('Bounce In Left',		'royal-event'),
				'bounceInRight'		=> esc_html__('Bounce In Right',	'royal-event'),
				'elastic'			=> esc_html__('Elastic In',			'royal-event'),
				'fadeIn'			=> esc_html__('Fade In',			'royal-event'),
				'fadeInUp'			=> esc_html__('Fade In Up',			'royal-event'),
				'fadeInUpSmall'		=> esc_html__('Fade In Up Small',	'royal-event'),
				'fadeInUpBig'		=> esc_html__('Fade In Up Big',		'royal-event'),
				'fadeInDown'		=> esc_html__('Fade In Down',		'royal-event'),
				'fadeInDownBig'		=> esc_html__('Fade In Down Big',	'royal-event'),
				'fadeInLeft'		=> esc_html__('Fade In Left',		'royal-event'),
				'fadeInLeftBig'		=> esc_html__('Fade In Left Big',	'royal-event'),
				'fadeInRight'		=> esc_html__('Fade In Right',		'royal-event'),
				'fadeInRightBig'	=> esc_html__('Fade In Right Big',	'royal-event'),
				'flipInX'			=> esc_html__('Flip In X',			'royal-event'),
				'flipInY'			=> esc_html__('Flip In Y',			'royal-event'),
				'lightSpeedIn'		=> esc_html__('Light Speed In',		'royal-event'),
				'rotateIn'			=> esc_html__('Rotate In',			'royal-event'),
				'rotateInUpLeft'	=> esc_html__('Rotate In Down Left','royal-event'),
				'rotateInUpRight'	=> esc_html__('Rotate In Up Right',	'royal-event'),
				'rotateInDownLeft'	=> esc_html__('Rotate In Up Left',	'royal-event'),
				'rotateInDownRight'	=> esc_html__('Rotate In Down Right','royal-event'),
				'rollIn'			=> esc_html__('Roll In',			'royal-event'),
				'slideInUp'			=> esc_html__('Slide In Up',		'royal-event'),
				'slideInDown'		=> esc_html__('Slide In Down',		'royal-event'),
				'slideInLeft'		=> esc_html__('Slide In Left',		'royal-event'),
				'slideInRight'		=> esc_html__('Slide In Right',		'royal-event'),
				'wipeInLeftTop'		=> esc_html__('Wipe In Left Top',	'royal-event'),
				'zoomIn'			=> esc_html__('Zoom In',			'royal-event'),
				'zoomInUp'			=> esc_html__('Zoom In Up',			'royal-event'),
				'zoomInDown'		=> esc_html__('Zoom In Down',		'royal-event'),
				'zoomInLeft'		=> esc_html__('Zoom In Left',		'royal-event'),
				'zoomInRight'		=> esc_html__('Zoom In Right',		'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_animations_in', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_animations_in', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the out animations
if ( !function_exists( 'royal_event_get_list_animations_out' ) ) {
	function royal_event_get_list_animations_out($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_animations_out'))=='') {
			$list = array(
				'none'				=> esc_html__('- None -',			'royal-event'),
				'bounceOut'			=> esc_html__('Bounce Out',			'royal-event'),
				'bounceOutUp'		=> esc_html__('Bounce Out Up',		'royal-event'),
				'bounceOutDown'		=> esc_html__('Bounce Out Down',	'royal-event'),
				'bounceOutLeft'		=> esc_html__('Bounce Out Left',	'royal-event'),
				'bounceOutRight'	=> esc_html__('Bounce Out Right',	'royal-event'),
				'fadeOut'			=> esc_html__('Fade Out',			'royal-event'),
				'fadeOutUp'			=> esc_html__('Fade Out Up',		'royal-event'),
				'fadeOutUpBig'		=> esc_html__('Fade Out Up Big',	'royal-event'),
				'fadeOutDown'		=> esc_html__('Fade Out Down',		'royal-event'),
				'fadeOutDownSmall'	=> esc_html__('Fade Out Down Small','royal-event'),
				'fadeOutDownBig'	=> esc_html__('Fade Out Down Big',	'royal-event'),
				'fadeOutLeft'		=> esc_html__('Fade Out Left',		'royal-event'),
				'fadeOutLeftBig'	=> esc_html__('Fade Out Left Big',	'royal-event'),
				'fadeOutRight'		=> esc_html__('Fade Out Right',		'royal-event'),
				'fadeOutRightBig'	=> esc_html__('Fade Out Right Big',	'royal-event'),
				'flipOutX'			=> esc_html__('Flip Out X',			'royal-event'),
				'flipOutY'			=> esc_html__('Flip Out Y',			'royal-event'),
				'hinge'				=> esc_html__('Hinge Out',			'royal-event'),
				'lightSpeedOut'		=> esc_html__('Light Speed Out',	'royal-event'),
				'rotateOut'			=> esc_html__('Rotate Out',			'royal-event'),
				'rotateOutUpLeft'	=> esc_html__('Rotate Out Down Left','royal-event'),
				'rotateOutUpRight'	=> esc_html__('Rotate Out Up Right','royal-event'),
				'rotateOutDownLeft'	=> esc_html__('Rotate Out Up Left',	'royal-event'),
				'rotateOutDownRight'=> esc_html__('Rotate Out Down Right','royal-event'),
				'rollOut'			=> esc_html__('Roll Out',			'royal-event'),
				'slideOutUp'		=> esc_html__('Slide Out Up',		'royal-event'),
				'slideOutDown'		=> esc_html__('Slide Out Down',		'royal-event'),
				'slideOutLeft'		=> esc_html__('Slide Out Left',		'royal-event'),
				'slideOutRight'		=> esc_html__('Slide Out Right',	'royal-event'),
				'zoomOut'			=> esc_html__('Zoom Out',			'royal-event'),
				'zoomOutUp'			=> esc_html__('Zoom Out Up',		'royal-event'),
				'zoomOutDown'		=> esc_html__('Zoom Out Down',		'royal-event'),
				'zoomOutLeft'		=> esc_html__('Zoom Out Left',		'royal-event'),
				'zoomOutRight'		=> esc_html__('Zoom Out Right',		'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_animations_out', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_animations_out', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return classes list for the specified animation
if (!function_exists('royal_event_get_animation_classes')) {
	function royal_event_get_animation_classes($animation, $speed='normal', $loop='none') {
		return royal_event_param_is_off($animation) ? '' : 'animated '.esc_attr($animation).' '.esc_attr($speed).(!royal_event_param_is_off($loop) ? ' '.esc_attr($loop) : '');
	}
}


// Return list of the main menu hover effects
if ( !function_exists( 'royal_event_get_list_menu_hovers' ) ) {
	function royal_event_get_list_menu_hovers($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_menu_hovers'))=='') {
			$list = array(
				'fade'			=> esc_html__('Fade',		'royal-event'),
				'slide_line'	=> esc_html__('Slide Line',	'royal-event'),
				'slide_box'		=> esc_html__('Slide Box',	'royal-event'),
				'zoom_line'		=> esc_html__('Zoom Line',	'royal-event'),
				'path_line'		=> esc_html__('Path Line',	'royal-event'),
				'roll_down'		=> esc_html__('Roll Down',	'royal-event'),
				'color_line'	=> esc_html__('Color Line',	'royal-event'),
				);
			$list = apply_filters('royal_event_filter_list_menu_hovers', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_menu_hovers', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the button's hover effects
if ( !function_exists( 'royal_event_get_list_button_hovers' ) ) {
	function royal_event_get_list_button_hovers($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_button_hovers'))=='') {
			$list = array(
				'default'		=> esc_html__('Default',			'royal-event'),
				'fade'			=> esc_html__('Fade',				'royal-event'),
				'slide_left'	=> esc_html__('Slide from Left',	'royal-event'),
				'slide_top'		=> esc_html__('Slide from Top',		'royal-event'),
				'arrow'			=> esc_html__('Arrow',				'royal-event'),
				);
			$list = apply_filters('royal_event_filter_list_button_hovers', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_button_hovers', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the input field's hover effects
if ( !function_exists( 'royal_event_get_list_input_hovers' ) ) {
	function royal_event_get_list_input_hovers($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_input_hovers'))=='') {
			$list = array(
				'default'	=> esc_html__('Default',	'royal-event'),
				'accent'	=> esc_html__('Accented',	'royal-event'),
				'path'		=> esc_html__('Path',		'royal-event'),
				'jump'		=> esc_html__('Jump',		'royal-event'),
				'underline'	=> esc_html__('Underline',	'royal-event'),
				'iconed'	=> esc_html__('Iconed',		'royal-event'),
				);
			$list = apply_filters('royal_event_filter_list_input_hovers', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_input_hovers', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the search field's styles
if ( !function_exists( 'royal_event_get_list_search_styles' ) ) {
	function royal_event_get_list_search_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_search_styles'))=='') {
			$list = array(
				'default'	=> esc_html__('Default',	'royal-event'),
				'fullscreen'=> esc_html__('Fullscreen',	'royal-event'),
				'slide'		=> esc_html__('Slide',		'royal-event'),
				'expand'	=> esc_html__('Expand',		'royal-event'),
				);
			$list = apply_filters('royal_event_filter_list_search_styles', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_search_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of categories
if ( !function_exists( 'royal_event_get_list_categories' ) ) {
	function royal_event_get_list_categories($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_categories'))=='') {
			$list = array();
			$args = array(
				'type'                     => 'post',
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => 'category',
				'pad_counts'               => false );
			$taxonomies = get_categories( $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_categories', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of taxonomies
if ( !function_exists( 'royal_event_get_list_terms' ) ) {
	function royal_event_get_list_terms($prepend_inherit=false, $taxonomy='category') {
		if (($list = royal_event_storage_get('list_taxonomies_'.($taxonomy)))=='') {
			$list = array();
			if ( is_array($taxonomy) || taxonomy_exists($taxonomy) ) {
				$terms = get_terms( $taxonomy, array(
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'name',
					'order'                    => 'ASC',
					'hide_empty'               => 0,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => $taxonomy,
					'pad_counts'               => false
					)
				);
			} else {
				$terms = royal_event_get_terms_by_taxonomy_from_db($taxonomy);
			}
			if (!is_wp_error( $terms ) && is_array($terms) && count($terms) > 0) {
				foreach ($terms as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_taxonomies_'.($taxonomy), $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list of post's types
if ( !function_exists( 'royal_event_get_list_posts_types' ) ) {
	function royal_event_get_list_posts_types($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_posts_types'))=='') {
			// Return only theme inheritance supported post types
			$list = apply_filters('royal_event_filter_list_post_types', array());
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_posts_types', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list post items from any post type and taxonomy
if ( !function_exists( 'royal_event_get_list_posts' ) ) {
	function royal_event_get_list_posts($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'post',
			'post_status'		=> 'publish',
			'taxonomy'			=> 'category',
			'taxonomy_value'	=> '',
			'posts_per_page'	=> -1,
			'orderby'			=> 'post_date',
			'order'				=> 'desc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));

		$hash = 'list_posts_'.($opt['post_type']).'_'.($opt['taxonomy']).'_'.($opt['taxonomy_value']).'_'.($opt['orderby']).'_'.($opt['order']).'_'.($opt['return']).'_'.($opt['posts_per_page']);
		if (($list = royal_event_storage_get($hash))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'royal-event');
			$args = array(
				'post_type' => $opt['post_type'],
				'post_status' => $opt['post_status'],
				'posts_per_page' => $opt['posts_per_page'],
				'ignore_sticky_posts' => true,
				'orderby'	=> $opt['orderby'],
				'order'		=> $opt['order']
			);
			if (!empty($opt['taxonomy_value'])) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => $opt['taxonomy'],
						'field' => (int) $opt['taxonomy_value'] > 0 ? 'id' : 'slug',
						'terms' => $opt['taxonomy_value']
					)
				);
			}
			$posts = get_posts( $args );
			if (is_array($posts) && count($posts) > 0) {
				foreach ($posts as $post) {
					$list[$opt['return']=='id' ? $post->ID : $post->post_title] = $post->post_title;
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set($hash, $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list pages
if ( !function_exists( 'royal_event_get_list_pages' ) ) {
	function royal_event_get_list_pages($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'page',
			'post_status'		=> 'publish',
			'posts_per_page'	=> -1,
			'orderby'			=> 'title',
			'order'				=> 'asc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));
		return royal_event_get_list_posts($prepend_inherit, $opt);
	}
}


// Return list of registered users
if ( !function_exists( 'royal_event_get_list_users' ) ) {
	function royal_event_get_list_users($prepend_inherit=false, $roles=array('administrator', 'editor', 'author', 'contributor', 'shop_manager')) {
		if (($list = royal_event_storage_get('list_users'))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'royal-event');
			$args = array(
				'orderby'	=> 'display_name',
				'order'		=> 'ASC' );
			$users = get_users( $args );
			if (is_array($users) && count($users) > 0) {
				foreach ($users as $user) {
					$accept = true;
					if (is_array($user->roles)) {
						if (is_array($user->roles) && count($user->roles) > 0) {
							$accept = false;
							foreach ($user->roles as $role) {
								if (in_array($role, $roles)) {
									$accept = true;
									break;
								}
							}
						}
					}
					if ($accept) $list[$user->user_login] = $user->display_name;
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_users', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return slider engines list, prepended inherit (if need)
if ( !function_exists( 'royal_event_get_list_sliders' ) ) {
	function royal_event_get_list_sliders($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_sliders'))=='') {
			$list = array(
				'swiper' => esc_html__("Posts slider (Swiper)", 'royal-event')
			);
			$list = apply_filters('royal_event_filter_list_sliders', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_sliders', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return slider controls list, prepended inherit (if need)
if ( !function_exists( 'royal_event_get_list_slider_controls' ) ) {
	function royal_event_get_list_slider_controls($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_slider_controls'))=='') {
			$list = array(
				'no'		=> esc_html__('None', 'royal-event'),
				'side'		=> esc_html__('Side', 'royal-event'),
				'bottom'	=> esc_html__('Bottom', 'royal-event'),
				'pagination'=> esc_html__('Pagination', 'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_slider_controls', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_slider_controls', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return slider controls classes
if ( !function_exists( 'royal_event_get_slider_controls_classes' ) ) {
	function royal_event_get_slider_controls_classes($controls) {
		if (royal_event_param_is_off($controls))	$classes = 'sc_slider_nopagination sc_slider_nocontrols';
		else if ($controls=='bottom')			$classes = 'sc_slider_nopagination sc_slider_controls sc_slider_controls_bottom';
		else if ($controls=='pagination')		$classes = 'sc_slider_pagination sc_slider_pagination_bottom sc_slider_nocontrols';
		else									$classes = 'sc_slider_nopagination sc_slider_controls sc_slider_controls_side';
		return $classes;
	}
}

// Return list with popup engines
if ( !function_exists( 'royal_event_get_list_popup_engines' ) ) {
	function royal_event_get_list_popup_engines($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_popup_engines'))=='') {
			$list = array(
				"pretty"	=> esc_html__("Pretty photo", 'royal-event'),
				"magnific"	=> esc_html__("Magnific popup", 'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_popup_engines', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_popup_engines', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return menus list, prepended inherit
if ( !function_exists( 'royal_event_get_list_menus' ) ) {
	function royal_event_get_list_menus($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_menus'))=='') {
			$list = array();
			$list['default'] = esc_html__("Default", 'royal-event');
			$menus = wp_get_nav_menus();
			if (is_array($menus) && count($menus) > 0) {
				foreach ($menus as $menu) {
					$list[$menu->slug] = $menu->name;
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_menus', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return custom sidebars list, prepended inherit and main sidebars item (if need)
if ( !function_exists( 'royal_event_get_list_sidebars' ) ) {
	function royal_event_get_list_sidebars($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_sidebars'))=='') {
			if (($list = royal_event_storage_get('registered_sidebars'))=='') $list = array();
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_sidebars', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return sidebars positions
if ( !function_exists( 'royal_event_get_list_sidebars_positions' ) ) {
	function royal_event_get_list_sidebars_positions($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_sidebars_positions'))=='') {
			$list = array(
				'none'  => esc_html__('Hide',  'royal-event'),
				'left'  => esc_html__('Left',  'royal-event'),
				'right' => esc_html__('Right', 'royal-event')
				);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_sidebars_positions', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return sidebars class
if ( !function_exists( 'royal_event_get_sidebar_class' ) ) {
	function royal_event_get_sidebar_class() {
		$sb_main = royal_event_get_custom_option('show_sidebar_main');
		$sb_outer = royal_event_get_custom_option('show_sidebar_outer');
		return (royal_event_param_is_off($sb_main) ? 'sidebar_hide' : 'sidebar_show sidebar_'.($sb_main))
				. ' ' . (royal_event_param_is_off($sb_outer) ? 'sidebar_outer_hide' : 'sidebar_outer_show sidebar_outer_'.($sb_outer));
	}
}

// Return body styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_body_styles' ) ) {
	function royal_event_get_list_body_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_body_styles'))=='') {
			$list = array(
				'boxed'	=> esc_html__('Boxed',		'royal-event'),
				'wide'	=> esc_html__('Wide',		'royal-event')
				);
			if (royal_event_get_theme_setting('allow_fullscreen')) {
				$list['fullwide']	= esc_html__('Fullwide',	'royal-event');
				$list['fullscreen']	= esc_html__('Fullscreen',	'royal-event');
			}
			$list = apply_filters('royal_event_filter_list_body_styles', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_body_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return templates list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates' ) ) {
	function royal_event_get_list_templates($mode='') {
		if (($list = royal_event_storage_get('list_templates_'.($mode)))=='') {
			$list = array();
			$tpl = royal_event_storage_get('registered_templates');
			if (is_array($tpl) && count($tpl) > 0) {
				foreach ($tpl as $k=>$v) {
					if ($mode=='' || in_array($mode, explode(',', $v['mode'])))
						$list[$k] = !empty($v['icon']) 
									? $v['icon'] 
									: (!empty($v['title']) 
										? $v['title'] 
										: royal_event_strtoproper($v['layout'])
										);
				}
			}
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_'.($mode), $list);
		}
		return $list;
	}
}

// Return blog styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates_blog' ) ) {
	function royal_event_get_list_templates_blog($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_templates_blog'))=='') {
			$list = royal_event_get_list_templates('blog');
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_blog', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return blogger styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates_blogger' ) ) {
	function royal_event_get_list_templates_blogger($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_templates_blogger'))=='') {
			$list = royal_event_array_merge(royal_event_get_list_templates('blogger'), royal_event_get_list_templates('blog'));
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_blogger', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return single page styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates_single' ) ) {
	function royal_event_get_list_templates_single($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_templates_single'))=='') {
			$list = royal_event_get_list_templates('single');
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_single', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return header styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates_header' ) ) {
	function royal_event_get_list_templates_header($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_templates_header'))=='') {
			$list = royal_event_get_list_templates('header');
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_header', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return form styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_templates_forms' ) ) {
	function royal_event_get_list_templates_forms($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_templates_forms'))=='') {
			$list = royal_event_get_list_templates('forms');
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_templates_forms', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return article styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_article_styles' ) ) {
	function royal_event_get_list_article_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_article_styles'))=='') {
			$list = array(
				"boxed"   => esc_html__('Boxed', 'royal-event'),
				"stretch" => esc_html__('Stretch', 'royal-event')
				);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_article_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return post-formats filters list, prepended inherit
if ( !function_exists( 'royal_event_get_list_post_formats_filters' ) ) {
	function royal_event_get_list_post_formats_filters($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_post_formats_filters'))=='') {
			$list = array(
				"no"      => esc_html__('All posts', 'royal-event'),
				"thumbs"  => esc_html__('With thumbs', 'royal-event'),
				"reviews" => esc_html__('With reviews', 'royal-event'),
				"video"   => esc_html__('With videos', 'royal-event'),
				"audio"   => esc_html__('With audios', 'royal-event'),
				"gallery" => esc_html__('With galleries', 'royal-event')
				);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_post_formats_filters', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return portfolio filters list, prepended inherit
if ( !function_exists( 'royal_event_get_list_portfolio_filters' ) ) {
	function royal_event_get_list_portfolio_filters($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_portfolio_filters'))=='') {
			$list = array(
				"hide"		=> esc_html__('Hide', 'royal-event'),
				"tags"		=> esc_html__('Tags', 'royal-event'),
				"categories"=> esc_html__('Categories', 'royal-event')
				);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_portfolio_filters', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return hover styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_hovers' ) ) {
	function royal_event_get_list_hovers($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_hovers'))=='') {
			$list = array();
			$list['circle effect1']  = esc_html__('Circle Effect 1',  'royal-event');
			$list['circle effect2']  = esc_html__('Circle Effect 2',  'royal-event');
			$list['circle effect3']  = esc_html__('Circle Effect 3',  'royal-event');
			$list['circle effect4']  = esc_html__('Circle Effect 4',  'royal-event');
			$list['circle effect5']  = esc_html__('Circle Effect 5',  'royal-event');
			$list['circle effect6']  = esc_html__('Circle Effect 6',  'royal-event');
			$list['circle effect7']  = esc_html__('Circle Effect 7',  'royal-event');
			$list['circle effect8']  = esc_html__('Circle Effect 8',  'royal-event');
			$list['circle effect9']  = esc_html__('Circle Effect 9',  'royal-event');
			$list['circle effect10'] = esc_html__('Circle Effect 10',  'royal-event');
			$list['circle effect11'] = esc_html__('Circle Effect 11',  'royal-event');
			$list['circle effect12'] = esc_html__('Circle Effect 12',  'royal-event');
			$list['circle effect13'] = esc_html__('Circle Effect 13',  'royal-event');
			$list['circle effect14'] = esc_html__('Circle Effect 14',  'royal-event');
			$list['circle effect15'] = esc_html__('Circle Effect 15',  'royal-event');
			$list['circle effect16'] = esc_html__('Circle Effect 16',  'royal-event');
			$list['circle effect17'] = esc_html__('Circle Effect 17',  'royal-event');
			$list['circle effect18'] = esc_html__('Circle Effect 18',  'royal-event');
			$list['circle effect19'] = esc_html__('Circle Effect 19',  'royal-event');
			$list['circle effect20'] = esc_html__('Circle Effect 20',  'royal-event');
			$list['square effect1']  = esc_html__('Square Effect 1',  'royal-event');
			$list['square effect2']  = esc_html__('Square Effect 2',  'royal-event');
			$list['square effect3']  = esc_html__('Square Effect 3',  'royal-event');
			$list['square effect5']  = esc_html__('Square Effect 5',  'royal-event');
			$list['square effect6']  = esc_html__('Square Effect 6',  'royal-event');
			$list['square effect7']  = esc_html__('Square Effect 7',  'royal-event');
			$list['square effect8']  = esc_html__('Square Effect 8',  'royal-event');
			$list['square effect9']  = esc_html__('Square Effect 9',  'royal-event');
			$list['square effect10'] = esc_html__('Square Effect 10',  'royal-event');
			$list['square effect11'] = esc_html__('Square Effect 11',  'royal-event');
			$list['square effect12'] = esc_html__('Square Effect 12',  'royal-event');
			$list['square effect13'] = esc_html__('Square Effect 13',  'royal-event');
			$list['square effect14'] = esc_html__('Square Effect 14',  'royal-event');
			$list['square effect15'] = esc_html__('Square Effect 15',  'royal-event');
			$list['square effect_dir']   = esc_html__('Square Effect Dir',   'royal-event');
			$list['square effect_shift'] = esc_html__('Square Effect Shift', 'royal-event');
			$list['square effect_book']  = esc_html__('Square Effect Book',  'royal-event');
			$list['square effect_more']  = esc_html__('Square Effect More',  'royal-event');
			$list['square effect_fade']  = esc_html__('Square Effect Fade',  'royal-event');
			$list['square effect_pull']  = esc_html__('Square Effect Pull',  'royal-event');
			$list['square effect_slide'] = esc_html__('Square Effect Slide', 'royal-event');
			$list['square effect_border'] = esc_html__('Square Effect Border', 'royal-event');
			$list = apply_filters('royal_event_filter_portfolio_hovers', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_hovers', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the blog counters
if ( !function_exists( 'royal_event_get_list_blog_counters' ) ) {
	function royal_event_get_list_blog_counters($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_blog_counters'))=='') {
			$list = array(
				'views'		=> esc_html__('Views', 'royal-event'),
				'likes'		=> esc_html__('Likes', 'royal-event'),
				'rating'	=> esc_html__('Rating', 'royal-event'),
				'comments'	=> esc_html__('Comments', 'royal-event')
				);
			$list = apply_filters('royal_event_filter_list_blog_counters', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_blog_counters', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list of the item sizes for the portfolio alter style, prepended inherit
if ( !function_exists( 'royal_event_get_list_alter_sizes' ) ) {
	function royal_event_get_list_alter_sizes($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_alter_sizes'))=='') {
			$list = array(
					'1_1' => esc_html__('1x1', 'royal-event'),
					'1_2' => esc_html__('1x2', 'royal-event'),
					'2_1' => esc_html__('2x1', 'royal-event'),
					'2_2' => esc_html__('2x2', 'royal-event'),
					'1_3' => esc_html__('1x3', 'royal-event'),
					'2_3' => esc_html__('2x3', 'royal-event'),
					'3_1' => esc_html__('3x1', 'royal-event'),
					'3_2' => esc_html__('3x2', 'royal-event'),
					'3_3' => esc_html__('3x3', 'royal-event')
					);
			$list = apply_filters('royal_event_filter_portfolio_alter_sizes', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_alter_sizes', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return extended hover directions list, prepended inherit
if ( !function_exists( 'royal_event_get_list_hovers_directions' ) ) {
	function royal_event_get_list_hovers_directions($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_hovers_directions'))=='') {
			$list = array(
				'left_to_right' => esc_html__('Left to Right',  'royal-event'),
				'right_to_left' => esc_html__('Right to Left',  'royal-event'),
				'top_to_bottom' => esc_html__('Top to Bottom',  'royal-event'),
				'bottom_to_top' => esc_html__('Bottom to Top',  'royal-event'),
				'scale_up'      => esc_html__('Scale Up',  'royal-event'),
				'scale_down'    => esc_html__('Scale Down',  'royal-event'),
				'scale_down_up' => esc_html__('Scale Down-Up',  'royal-event'),
				'from_left_and_right' => esc_html__('From Left and Right',  'royal-event'),
				'from_top_and_bottom' => esc_html__('From Top and Bottom',  'royal-event')
			);
			$list = apply_filters('royal_event_filter_portfolio_hovers_directions', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_hovers_directions', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the label positions in the custom forms
if ( !function_exists( 'royal_event_get_list_label_positions' ) ) {
	function royal_event_get_list_label_positions($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_label_positions'))=='') {
			$list = array(
				'top'		=> esc_html__('Top',		'royal-event'),
				'bottom'	=> esc_html__('Bottom',		'royal-event'),
				'left'		=> esc_html__('Left',		'royal-event'),
				'over'		=> esc_html__('Over',		'royal-event')
			);
			$list = apply_filters('royal_event_filter_label_positions', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_label_positions', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the bg image positions
if ( !function_exists( 'royal_event_get_list_bg_image_positions' ) ) {
	function royal_event_get_list_bg_image_positions($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_bg_image_positions'))=='') {
			$list = array(
				'left top'	   => esc_html__('Left Top', 'royal-event'),
				'center top'   => esc_html__("Center Top", 'royal-event'),
				'right top'    => esc_html__("Right Top", 'royal-event'),
				'left center'  => esc_html__("Left Center", 'royal-event'),
				'center center'=> esc_html__("Center Center", 'royal-event'),
				'right center' => esc_html__("Right Center", 'royal-event'),
				'left bottom'  => esc_html__("Left Bottom", 'royal-event'),
				'center bottom'=> esc_html__("Center Bottom", 'royal-event'),
				'right bottom' => esc_html__("Right Bottom", 'royal-event')
			);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_bg_image_positions', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the bg image repeat
if ( !function_exists( 'royal_event_get_list_bg_image_repeats' ) ) {
	function royal_event_get_list_bg_image_repeats($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_bg_image_repeats'))=='') {
			$list = array(
				'repeat'	=> esc_html__('Repeat', 'royal-event'),
				'repeat-x'	=> esc_html__('Repeat X', 'royal-event'),
				'repeat-y'	=> esc_html__('Repeat Y', 'royal-event'),
				'no-repeat'	=> esc_html__('No Repeat', 'royal-event')
			);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_bg_image_repeats', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the bg image attachment
if ( !function_exists( 'royal_event_get_list_bg_image_attachments' ) ) {
	function royal_event_get_list_bg_image_attachments($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_bg_image_attachments'))=='') {
			$list = array(
				'scroll'	=> esc_html__('Scroll', 'royal-event'),
				'fixed'		=> esc_html__('Fixed', 'royal-event'),
				'local'		=> esc_html__('Local', 'royal-event')
			);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_bg_image_attachments', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}


// Return list of the bg tints
if ( !function_exists( 'royal_event_get_list_bg_tints' ) ) {
	function royal_event_get_list_bg_tints($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_bg_tints'))=='') {
			$list = array(
				'white'	=> esc_html__('White', 'royal-event'),
				'light'	=> esc_html__('Light', 'royal-event'),
				'dark'	=> esc_html__('Dark', 'royal-event')
			);
			$list = apply_filters('royal_event_filter_bg_tints', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_bg_tints', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return custom fields types list, prepended inherit
if ( !function_exists( 'royal_event_get_list_field_types' ) ) {
	function royal_event_get_list_field_types($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_field_types'))=='') {
			$list = array(
				'text'     => esc_html__('Text',  'royal-event'),
				'textarea' => esc_html__('Text Area','royal-event'),
				'password' => esc_html__('Password',  'royal-event'),
				'radio'    => esc_html__('Radio',  'royal-event'),
				'checkbox' => esc_html__('Checkbox',  'royal-event'),
				'select'   => esc_html__('Select',  'royal-event'),
				'date'     => esc_html__('Date','royal-event'),
				'time'     => esc_html__('Time','royal-event'),
				'button'   => esc_html__('Button','royal-event')
			);
			$list = apply_filters('royal_event_filter_field_types', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_field_types', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return Google map styles
if ( !function_exists( 'royal_event_get_list_googlemap_styles' ) ) {
	function royal_event_get_list_googlemap_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_googlemap_styles'))=='') {
			$list = array(
				'default' => esc_html__('Default', 'royal-event')
			);
			$list = apply_filters('royal_event_filter_googlemap_styles', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_googlemap_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return iconed classes list
if ( !function_exists( 'royal_event_get_list_icons' ) ) {
	function royal_event_get_list_icons($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_icons'))=='') {
			$list = royal_event_parse_icons_classes(royal_event_get_file_dir("css/fontello/css/fontello-codes.css"));
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_icons', $list);
		}
		return $prepend_inherit ? array_merge(array('inherit'), $list) : $list;
	}
}

// Return socials list
if ( !function_exists( 'royal_event_get_list_socials' ) ) {
	function royal_event_get_list_socials($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_socials'))=='') {
			$list = royal_event_get_list_images("images/socials", "png");
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_socials', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with 'Yes' and 'No' items
if ( !function_exists( 'royal_event_get_list_yesno' ) ) {
	function royal_event_get_list_yesno($prepend_inherit=false) {
		$list = array(
			'yes' => esc_html__("Yes", 'royal-event'),
			'no'  => esc_html__("No", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with 'On' and 'Of' items
if ( !function_exists( 'royal_event_get_list_onoff' ) ) {
	function royal_event_get_list_onoff($prepend_inherit=false) {
		$list = array(
			"on" => esc_html__("On", 'royal-event'),
			"off" => esc_html__("Off", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with 'Show' and 'Hide' items
if ( !function_exists( 'royal_event_get_list_showhide' ) ) {
	function royal_event_get_list_showhide($prepend_inherit=false) {
		$list = array(
			"show" => esc_html__("Show", 'royal-event'),
			"hide" => esc_html__("Hide", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with 'Ascending' and 'Descending' items
if ( !function_exists( 'royal_event_get_list_orderings' ) ) {
	function royal_event_get_list_orderings($prepend_inherit=false) {
		$list = array(
			"asc" => esc_html__("Ascending", 'royal-event'),
			"desc" => esc_html__("Descending", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with 'Horizontal' and 'Vertical' items
if ( !function_exists( 'royal_event_get_list_directions' ) ) {
	function royal_event_get_list_directions($prepend_inherit=false) {
		$list = array(
			"horizontal" => esc_html__("Horizontal", 'royal-event'),
			"vertical" => esc_html__("Vertical", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with item's shapes
if ( !function_exists( 'royal_event_get_list_shapes' ) ) {
	function royal_event_get_list_shapes($prepend_inherit=false) {
		$list = array(
			"round"  => esc_html__("Round", 'royal-event'),
			"square" => esc_html__("Square", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with item's sizes
if ( !function_exists( 'royal_event_get_list_sizes' ) ) {
	function royal_event_get_list_sizes($prepend_inherit=false) {
		$list = array(
			"tiny"   => esc_html__("Tiny", 'royal-event'),
			"small"  => esc_html__("Small", 'royal-event'),
			"medium" => esc_html__("Medium", 'royal-event'),
			"large"  => esc_html__("Large", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with slider (scroll) controls positions
if ( !function_exists( 'royal_event_get_list_controls' ) ) {
	function royal_event_get_list_controls($prepend_inherit=false) {
		$list = array(
			"hide" => esc_html__("Hide", 'royal-event'),
			"side" => esc_html__("Side", 'royal-event'),
			"bottom" => esc_html__("Bottom", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with float items
if ( !function_exists( 'royal_event_get_list_floats' ) ) {
	function royal_event_get_list_floats($prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'royal-event'),
			"left" => esc_html__("Float Left", 'royal-event'),
			"right" => esc_html__("Float Right", 'royal-event')
		);
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with alignment items
if ( !function_exists( 'royal_event_get_list_alignments' ) ) {
	function royal_event_get_list_alignments($justify=false, $prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'royal-event'),
			"left" => esc_html__("Left", 'royal-event'),
			"center" => esc_html__("Center", 'royal-event'),
			"right" => esc_html__("Right", 'royal-event')
		);
		if ($justify) $list["justify"] = esc_html__("Justify", 'royal-event');
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with horizontal positions
if ( !function_exists( 'royal_event_get_list_hpos' ) ) {
	function royal_event_get_list_hpos($prepend_inherit=false, $center=false) {
		$list = array();
		$list['left'] = esc_html__("Left", 'royal-event');
		if ($center) $list['center'] = esc_html__("Center", 'royal-event');
		$list['right'] = esc_html__("Right", 'royal-event');
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with vertical positions
if ( !function_exists( 'royal_event_get_list_vpos' ) ) {
	function royal_event_get_list_vpos($prepend_inherit=false, $center=false) {
		$list = array();
		$list['top'] = esc_html__("Top", 'royal-event');
		if ($center) $list['center'] = esc_html__("Center", 'royal-event');
		$list['bottom'] = esc_html__("Bottom", 'royal-event');
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return sorting list items
if ( !function_exists( 'royal_event_get_list_sortings' ) ) {
	function royal_event_get_list_sortings($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_sortings'))=='') {
			$list = array(
				"date" => esc_html__("Date", 'royal-event'),
				"title" => esc_html__("Alphabetically", 'royal-event'),
				"views" => esc_html__("Popular (views count)", 'royal-event'),
				"comments" => esc_html__("Most commented (comments count)", 'royal-event'),
				"author_rating" => esc_html__("Author rating", 'royal-event'),
				"users_rating" => esc_html__("Visitors (users) rating", 'royal-event'),
				"random" => esc_html__("Random", 'royal-event')
			);
			$list = apply_filters('royal_event_filter_list_sortings', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_sortings', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list with columns widths
if ( !function_exists( 'royal_event_get_list_columns' ) ) {
	function royal_event_get_list_columns($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_columns'))=='') {
			$list = array(
				"none" => esc_html__("None", 'royal-event'),
				"1_1" => esc_html__("100%", 'royal-event'),
				"1_2" => esc_html__("1/2", 'royal-event'),
				"1_3" => esc_html__("1/3", 'royal-event'),
				"2_3" => esc_html__("2/3", 'royal-event'),
				"1_4" => esc_html__("1/4", 'royal-event'),
				"3_4" => esc_html__("3/4", 'royal-event'),
				"1_5" => esc_html__("1/5", 'royal-event'),
				"2_5" => esc_html__("2/5", 'royal-event'),
				"3_5" => esc_html__("3/5", 'royal-event'),
				"4_5" => esc_html__("4/5", 'royal-event'),
				"1_6" => esc_html__("1/6", 'royal-event'),
				"5_6" => esc_html__("5/6", 'royal-event'),
				"1_7" => esc_html__("1/7", 'royal-event'),
				"2_7" => esc_html__("2/7", 'royal-event'),
				"3_7" => esc_html__("3/7", 'royal-event'),
				"4_7" => esc_html__("4/7", 'royal-event'),
				"5_7" => esc_html__("5/7", 'royal-event'),
				"6_7" => esc_html__("6/7", 'royal-event'),
				"1_8" => esc_html__("1/8", 'royal-event'),
				"3_8" => esc_html__("3/8", 'royal-event'),
				"5_8" => esc_html__("5/8", 'royal-event'),
				"7_8" => esc_html__("7/8", 'royal-event'),
				"1_9" => esc_html__("1/9", 'royal-event'),
				"2_9" => esc_html__("2/9", 'royal-event'),
				"4_9" => esc_html__("4/9", 'royal-event'),
				"5_9" => esc_html__("5/9", 'royal-event'),
				"7_9" => esc_html__("7/9", 'royal-event'),
				"8_9" => esc_html__("8/9", 'royal-event'),
				"1_10"=> esc_html__("1/10", 'royal-event'),
				"3_10"=> esc_html__("3/10", 'royal-event'),
				"7_10"=> esc_html__("7/10", 'royal-event'),
				"9_10"=> esc_html__("9/10", 'royal-event'),
				"1_11"=> esc_html__("1/11", 'royal-event'),
				"2_11"=> esc_html__("2/11", 'royal-event'),
				"3_11"=> esc_html__("3/11", 'royal-event'),
				"4_11"=> esc_html__("4/11", 'royal-event'),
				"5_11"=> esc_html__("5/11", 'royal-event'),
				"6_11"=> esc_html__("6/11", 'royal-event'),
				"7_11"=> esc_html__("7/11", 'royal-event'),
				"8_11"=> esc_html__("8/11", 'royal-event'),
				"9_11"=> esc_html__("9/11", 'royal-event'),
				"10_11"=> esc_html__("10/11", 'royal-event'),
				"1_12"=> esc_html__("1/12", 'royal-event'),
				"5_12"=> esc_html__("5/12", 'royal-event'),
				"7_12"=> esc_html__("7/12", 'royal-event'),
				"10_12"=> esc_html__("10/12", 'royal-event'),
				"11_12"=> esc_html__("11/12", 'royal-event')
			);
			$list = apply_filters('royal_event_filter_list_columns', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_columns', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return list of locations for the dedicated content
if ( !function_exists( 'royal_event_get_list_dedicated_locations' ) ) {
	function royal_event_get_list_dedicated_locations($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_dedicated_locations'))=='') {
			$list = array(
				"default" => esc_html__('As in the post defined', 'royal-event'),
				"center"  => esc_html__('Above the text of the post', 'royal-event'),
				"left"    => esc_html__('To the left the text of the post', 'royal-event'),
				"right"   => esc_html__('To the right the text of the post', 'royal-event'),
				"alter"   => esc_html__('Alternates for each post', 'royal-event')
			);
			$list = apply_filters('royal_event_filter_list_dedicated_locations', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_dedicated_locations', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return post-format name
if ( !function_exists( 'royal_event_get_post_format_name' ) ) {
	function royal_event_get_post_format_name($format, $single=true) {
		$name = '';
		if ($format=='gallery')		$name = $single ? esc_html__('gallery', 'royal-event') : esc_html__('galleries', 'royal-event');
		else if ($format=='video')	$name = $single ? esc_html__('video', 'royal-event') : esc_html__('videos', 'royal-event');
		else if ($format=='audio')	$name = $single ? esc_html__('audio', 'royal-event') : esc_html__('audios', 'royal-event');
		else if ($format=='image')	$name = $single ? esc_html__('image', 'royal-event') : esc_html__('images', 'royal-event');
		else if ($format=='quote')	$name = $single ? esc_html__('quote', 'royal-event') : esc_html__('quotes', 'royal-event');
		else if ($format=='link')	$name = $single ? esc_html__('link', 'royal-event') : esc_html__('links', 'royal-event');
		else if ($format=='status')	$name = $single ? esc_html__('status', 'royal-event') : esc_html__('statuses', 'royal-event');
		else if ($format=='aside')	$name = $single ? esc_html__('aside', 'royal-event') : esc_html__('asides', 'royal-event');
		else if ($format=='chat')	$name = $single ? esc_html__('chat', 'royal-event') : esc_html__('chats', 'royal-event');
		else						$name = $single ? esc_html__('standard', 'royal-event') : esc_html__('standards', 'royal-event');
		return apply_filters('royal_event_filter_list_post_format_name', $name, $format);
	}
}

// Return post-format icon name (from Fontello library)
if ( !function_exists( 'royal_event_get_post_format_icon' ) ) {
	function royal_event_get_post_format_icon($format) {
		$icon = 'icon-';
		if ($format=='gallery')		$icon .= 'pictures';
		else if ($format=='video')	$icon .= 'video';
		else if ($format=='audio')	$icon .= 'note';
		else if ($format=='image')	$icon .= 'picture';
		else if ($format=='quote')	$icon .= 'quote';
		else if ($format=='link')	$icon .= 'link';
		else if ($format=='status')	$icon .= 'comment';
		else if ($format=='aside')	$icon .= 'doc-text';
		else if ($format=='chat')	$icon .= 'chat';
		else						$icon .= 'book-open';
		return apply_filters('royal_event_filter_list_post_format_icon', $icon, $format);
	}
}

// Return fonts styles list, prepended inherit
if ( !function_exists( 'royal_event_get_list_fonts_styles' ) ) {
	function royal_event_get_list_fonts_styles($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_fonts_styles'))=='') {
			$list = array(
				'i' => esc_html__('I','royal-event'),
				'u' => esc_html__('U', 'royal-event')
			);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_fonts_styles', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return Google fonts list
if ( !function_exists( 'royal_event_get_list_fonts' ) ) {
	function royal_event_get_list_fonts($prepend_inherit=false) {
		if (($list = royal_event_storage_get('list_fonts'))=='') {
			$list = array();
			$list = royal_event_array_merge($list, royal_event_get_list_font_faces());
			$list = royal_event_array_merge($list, array(
				'Advent Pro' => array('family'=>'sans-serif'),
				'Alegreya Sans' => array('family'=>'sans-serif'),
				'Arimo' => array('family'=>'sans-serif'),
				'Asap' => array('family'=>'sans-serif'),
				'Averia Sans Libre' => array('family'=>'cursive'),
				'Averia Serif Libre' => array('family'=>'cursive'),
				'Bree Serif' => array('family'=>'serif',),
				'Cabin' => array('family'=>'sans-serif'),
				'Cabin Condensed' => array('family'=>'sans-serif'),
				'Caudex' => array('family'=>'serif'),
				'Comfortaa' => array('family'=>'cursive'),
				'Cousine' => array('family'=>'sans-serif'),
				'Crimson Text' => array('family'=>'serif'),
				'Cuprum' => array('family'=>'sans-serif'),
				'Dosis' => array('family'=>'sans-serif'),
				'Economica' => array('family'=>'sans-serif'),
				'Exo' => array('family'=>'sans-serif'),
				'Expletus Sans' => array('family'=>'cursive'),
				'Karla' => array('family'=>'sans-serif'),
				'Lato' => array('family'=>'sans-serif'),
				'Lekton' => array('family'=>'sans-serif'),
				'Lobster Two' => array('family'=>'cursive'),
				'Maven Pro' => array('family'=>'sans-serif'),
				'Merriweather' => array('family'=>'serif'),
				'Montserrat' => array('family'=>'sans-serif'),
				'Neuton' => array('family'=>'serif'),
				'Noticia Text' => array('family'=>'serif'),
				'Old Standard TT' => array('family'=>'serif'),
				'Open Sans' => array('family'=>'sans-serif'),
				'Orbitron' => array('family'=>'sans-serif'),
				'Oswald' => array('family'=>'sans-serif'),
				'Overlock' => array('family'=>'cursive'),
				'Oxygen' => array('family'=>'sans-serif'),
				'Philosopher' => array('family'=>'serif'),
				'PT Serif' => array('family'=>'serif'),
				'Puritan' => array('family'=>'sans-serif'),
				'Raleway' => array('family'=>'sans-serif'),
				'Roboto' => array('family'=>'sans-serif'),
				'Roboto Slab' => array('family'=>'sans-serif'),
				'Roboto Condensed' => array('family'=>'sans-serif'),
				'Rosario' => array('family'=>'sans-serif'),
				'Share' => array('family'=>'cursive'),
				'Signika' => array('family'=>'sans-serif'),
				'Signika Negative' => array('family'=>'sans-serif'),
				'Source Sans Pro' => array('family'=>'sans-serif'),
				'Tinos' => array('family'=>'serif'),
				'Ubuntu' => array('family'=>'sans-serif'),
				'Vollkorn' => array('family'=>'serif'),
                'Yellowtail' => array('family'=>'sans-serif')
                )
			);
			$list = apply_filters('royal_event_filter_list_fonts', $list);
			if (royal_event_get_theme_setting('use_list_cache')) royal_event_storage_set('list_fonts', $list);
		}
		return $prepend_inherit ? royal_event_array_merge(array('inherit' => esc_html__("Inherit", 'royal-event')), $list) : $list;
	}
}

// Return Custom font-face list
if ( !function_exists( 'royal_event_get_list_font_faces' ) ) {
	function royal_event_get_list_font_faces($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$fonts = royal_event_storage_get('required_custom_fonts');
		$list = array();
		if (is_array($fonts)) {
			foreach ($fonts as $font) {
				if (($url = royal_event_get_file_url('css/font-face/'.trim($font).'/stylesheet.css'))!='') {
					$list[sprintf(esc_html__('%s', 'royal-event'), $font)] = array('css' => $url);
				}
			}
		}
		return $list;
	}
}
?>