<?php
/**
 * The template for displaying the footer.
 */

				royal_event_close_wrapper();	// <!-- </.content> -->

				// Show main sidebar
				get_sidebar();

				if (royal_event_get_custom_option('body_style')!='fullscreen') royal_event_close_wrapper();	// <!-- </.content_wrap> -->
				?>
			
			</div>		<!-- </.page_content_wrap> -->
			
			<?php
			// Footer Testimonials stream
			if (royal_event_get_custom_option('show_testimonials_in_footer')=='yes' && (function_exists('royal_event_sc_testimonials'))) {
				$count = max(1, royal_event_get_custom_option('testimonials_count'));
					$data = royal_event_sc_testimonials(array('count' => $count));
				if ($data) {
					?>
					<footer class="testimonials_wrap sc_section scheme_<?php echo esc_attr(royal_event_get_custom_option('testimonials_scheme')); ?>">
						<div class="testimonials_wrap_inner sc_section_inner sc_section_overlay">
							<div class="content_wrap"><?php royal_event_show_layout($data); ?></div>
						</div>
					</footer>
					<?php
				}
			}
			
			// Footer sidebar
			$footer_show  = royal_event_get_custom_option('show_sidebar_footer');
			$sidebar_name = royal_event_get_custom_option('sidebar_footer');
			if (!royal_event_param_is_off($footer_show) && is_active_sidebar($sidebar_name)) { 
				royal_event_storage_set('current_sidebar', 'footer');
				?>
				<footer class="footer_wrap widget_area scheme_<?php echo esc_attr(royal_event_get_custom_option('sidebar_footer_scheme')); ?>">
					<div class="footer_wrap_inner widget_area_inner">
						<div class="content_wrap">
							<div class="columns_wrap"><?php
							ob_start();
							do_action( 'before_sidebar' );

                                if ( is_active_sidebar( $sidebar_name ) ) {
                                    dynamic_sidebar( $sidebar_name );
                                }
							do_action( 'after_sidebar' );
							$out = ob_get_contents();
							ob_end_clean();
							royal_event_show_layout(chop(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $out)));
							?></div>	<!-- /.columns_wrap -->
						</div>	<!-- /.content_wrap -->
					</div>	<!-- /.footer_wrap_inner -->
				</footer>	<!-- /.footer_wrap -->
				<?php
			}


			// Footer Twitter stream
			if (royal_event_get_custom_option('show_twitter_in_footer')=='yes' && function_exists('royal_event_sc_twitter')) {
				$count = max(1, royal_event_get_custom_option('twitter_count'));
				$data = royal_event_sc_twitter(array('count'=>$count));
				if ($data) {
					?>
					<footer class="twitter_wrap sc_section scheme_<?php echo esc_attr(royal_event_get_custom_option('twitter_scheme')); ?>">
						<div class="twitter_wrap_inner sc_section_inner sc_section_overlay">
							<div class="content_wrap"><?php royal_event_show_layout($data); ?></div>
						</div>
					</footer>
					<?php
				}
			}


			// Google map
			if ( royal_event_get_custom_option('show_googlemap')=='yes' ) { 
				$map_address = royal_event_get_custom_option('googlemap_address');
				$map_latlng  = royal_event_get_custom_option('googlemap_latlng');
				$map_zoom    = royal_event_get_custom_option('googlemap_zoom');
				$map_style   = royal_event_get_custom_option('googlemap_style');
				$map_height  = royal_event_get_custom_option('googlemap_height');
				if (!empty($map_address) || !empty($map_latlng)) {
					$args = array();
					if (!empty($map_style))		$args['style'] = esc_attr($map_style);
					if (!empty($map_zoom))		$args['zoom'] = esc_attr($map_zoom);
					if (!empty($map_height))	$args['height'] = esc_attr($map_height);
					if (function_exists('royal_event_sc_googlemap')) {
						royal_event_show_layout(royal_event_sc_googlemap($args));
					}
				}
			}

			// Footer contacts
			if (royal_event_get_custom_option('show_contacts_in_footer')=='yes') { 
				$address_1 = royal_event_get_theme_option('contact_address_1');
				$address_2 = royal_event_get_theme_option('contact_address_2');
				$contact_phone = royal_event_get_theme_option('contact_phone');
				$contact_email = royal_event_get_theme_option('contact_email');
				if (!empty($address_1) || !empty($address_2) || !empty($phone) || !empty($email)) {
					?>
					<footer class="contacts_wrap scheme_<?php echo esc_attr(royal_event_get_custom_option('contacts_scheme')); ?>">
						<div class="contacts_wrap_inner">
							<div class="content_wrap">
								<div class="contacts_address">
									<div class="address_right">
										<?php if (!empty($contact_phone)) ?><a href="tel:<?php echo esc_attr($contact_phone); ?>"><?php royal_event_show_layout($contact_phone); ?></a><br>
										<?php if (!empty($contact_email)) ?><a href="mailto:<?php echo antispambot($contact_email); ?>"><?php royal_event_show_layout($contact_email); ?></a>
									</div>
                                    <?php royal_event_show_logo(false, false, true); ?>
                                    <div class="address_left">
										<?php if (!empty($address_2)) echo esc_html($address_2) . '<br>'; ?>
										<?php if (!empty($address_1)) echo esc_html($address_1); ?>
									</div>
								</div>
								<?php
								if (function_exists('royal_event_sc_socials')) {
									royal_event_show_layout(royal_event_sc_socials(array('size' => "tiny")));
								}
								?>
							</div>	<!-- /.content_wrap -->
						</div>	<!-- /.contacts_wrap_inner -->
					</footer>	<!-- /.contacts_wrap -->
					<?php
				}
			}

			// Copyright area
			$copyright_style = royal_event_get_custom_option('show_copyright_in_footer');
			if (!royal_event_param_is_off($copyright_style)) {
				?> 
				<footer class="copyright_wrap copyright_style_<?php echo esc_attr($copyright_style); ?>  scheme_<?php echo esc_attr(royal_event_get_custom_option('copyright_scheme')); ?>">
					<div class="copyright_wrap_inner">
						<div class="content_wrap">
							<?php
							if ($copyright_style == 'menu') {
								if (($menu = royal_event_get_nav_menu('menu_footer'))!='') {
									royal_event_show_layout($menu);
								}
							} else if ($copyright_style == 'socials' && function_exists('royal_event_sc_socials') ) {
								royal_event_show_layout(royal_event_sc_socials(array('size'=>"tiny")));
							}
							?>
							<div class="copyright"><?php royal_event_show_layout(do_shortcode(str_replace(array('{{Y}}', '{Y}'), date('Y'), royal_event_get_custom_option('footer_copyright')))); ?>
						    </div>
					    </div>
                    </div>
				</footer>
				<?php
			}
			?>
			
		</div>	<!-- /.page_wrap -->

	</div>		<!-- /.body_wrap -->
	
	<?php if ( !royal_event_param_is_off(royal_event_get_custom_option('show_sidebar_outer')) ) { ?>
	</div>	<!-- /.outer_wrap -->
	<?php } ?>

	<?php wp_footer(); ?>

</body>
</html>