<?php
namespace AnggitaPlugin\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit; // Exit if accessed directly



/**
 * @since 1.1.0
 */
class Anggita_PortfolioAjax extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'anggita-portfolio-ajax';
	}

	//script depend
	public function get_script_depends()
	{
		return ['jquery-isotope', 'anggita-portfolio', 'anggita-portfolio-ajax'];
	}
	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('Anggita Portfolio Ajax', 'anggita_plugin');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'fa fa-file-archive-o';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['anggita-elements'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'section_content',
			[
				'label' => __('Portfolio Settings.', 'anggita_plugin'),
			]
		);

		$this->add_control(
			'port_style',
			[
				'label' => __('Style', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __('Style One', 'anggita_plugin'),
					'2' => __('Style Two', 'anggita_plugin'),
					'3' => __('Style Three', 'anggita_plugin'),
				],
				'default' => '1',
			]
		);

		$this->add_responsive_control(
			'filter',
			[
				'label' => __('Filter', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __('Show', 'anggita_plugin'),
					'none' => __('Hide', 'anggita_plugin'),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .port-filter' => 'display: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'filter_align',
			[
				'label' => __('Filter Alignment', 'anggita_plugin'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'anggita_plugin'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'anggita_plugin'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __('Right', 'anggita_plugin'),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .port-filter' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'filter_all',
			[
				'label' => __('Text for all category. The default text is "All".', 'anggita_plugin'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => 'Leave it blank to use the default text.',
			]
		);

		$this->add_control(
			'load_more',
			[
				'label' => __('Text for load more portfolio button.', 'anggita_plugin'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => 'Leave it blank if you dont want to use any text.',
				'default' => 'Load More.',
			]
		);
		$this->add_control(
			'nomore',
			[
				'label' => __('Text for no more portfolio.', 'anggita_plugin'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => 'Leave it blank if you dont want to use any text.',
				'default' => 'No More Portfolio.',
			]
		);


		$this->add_control(
			'portfolio_item',
			[
				'label' => __('Item to display', 'anggita_plugin'),
				'type' => Controls_Manager::NUMBER,
				'default' => '8',
			]
		);
		$this->add_control(
			'load_show',
			[
				'label' => __('Show Load More Button', 'anggita_plugin'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'label_on' => __('yes', 'anggita_plugin'),
				'label_off' => __('no', 'anggita_plugin'),
				'return_value' => 'yes',
			]
		);



		$this->add_control(
			'port_order',
			[
				'label' => __('Orders', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'DESC' => __('Descending', 'anggita_plugin'),
					'ASC' => __('Ascending', 'anggita_plugin'),
				],
				'default' => 'DESC',
			]
		);


		$this->add_control(
			'port_column',
			[
				'label' => __('Columns', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'2' => __('Two Columns', 'anggita_plugin'),
					'3' => __('Three Columns', 'anggita_plugin'),
					'4' => __('Four Columns', 'anggita_plugin'),
				],
				'default' => '3',
			]
		);



		$this->end_controls_section();


		$this->start_controls_section(
			'portfolio_styling',
			[
				'label' => __('<div style="padding:10px 0;">Portfolio Item Settings.  <br/><small style="font-weight:normal;">You can click the (All) filter to refresh the layout when you change the Height settings.</small></div>', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'portfolio_margin',
			[
				'label' => __('Margin', 'anggita_plugin'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .port-inner' => 'margin: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .portfolio-body' => 'margin: -{{SIZE}}{{UNIT}} -{{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'portfolio_height',
			[
				'label' => __('Height', 'anggita_plugin'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .port-box' => 'padding: {{SIZE}}% 0;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __('Content Settings', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);



		$this->add_responsive_control(
			'port_content',
			[
				'label' => __('Content Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .port-dbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'port_padding',
			[
				'label' => __('Content Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'port_border',
				'placeholder' => '1px',
				'default' => '',
				'selector' => '{{WRAPPER}} .dbox-relative',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'bg_content',
			[
				'label' => __('Content Background', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'condition' => [
					'port_style' => '1',
				],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_responsive_control(
			'content_align',
			[
				'label' => __('Alignment', 'anggita_plugin'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'anggita_plugin'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'anggita_plugin'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __('Right', 'anggita_plugin'),
						'icon' => 'fa fa-align-right',
					]
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_typo',
			[
				'label' => __('Title Content Settings', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'cport_typography',
				'label'     => __('Title Typography', 'anggita_plugin'),
				'selector'  => '{{WRAPPER}} .dbox-relative h3',
			]
		);

		$this->add_control(
			'title_type',
			[
				'label' => __('Title Display', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __('Block', 'anggita_plugin'),
					'inline-block' => __('Inline Block', 'anggita_plugin'),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'display: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_cl',
			[
				'label' => __('Title Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_cl_hover',
			[
				'label' => __('Title Color on hover', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-type-two .port-inner:hover .dbox-relative h3' => 'color: {{VALUE}};'
				],
				'condition' => [
					'port_style' => '2',
				],
			]
		);
		$this->add_control(
			'title_bgl',
			[
				'label' => __('Title Background Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'titlep_padding',
			[
				'label' => __('Title Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'titlep_margin',
			[
				'label' => __('Title Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'sub_typo',
			[
				'label' => __('Category/Text Content Settings', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'ctext_typography',
				'label'     => __('Text Typography', 'anggita_plugin'),
				'selector'  => '{{WRAPPER}} .dbox-relative p',
			]
		);

		$this->add_control(
			'text_type',
			[
				'label' => __('Text Display', 'anggita_plugin'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __('Block', 'anggita_plugin'),
					'inline-block' => __('Inline Block', 'anggita_plugin'),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'display: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'txt_cl',
			[
				'label' => __('Text Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'txt_cl_hover',
			[
				'label' => __('Text Color on hover', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-type-two .port-inner:hover .dbox-relative p' => 'color: {{VALUE}};'
				],
				'condition' => [
					'port_style' => '2',
				],
			]
		);

		$this->add_control(
			'txt_bg',
			[
				'label' => __('Text Background Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'tx_padding',
			[
				'label' => __('Text Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'tx_margin',
			[
				'label' => __('Text Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->end_controls_section();


		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __('Filter Settings', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'filter_typography',
				'label'     => __('Typography', 'anggita_plugin'),
				'selector'  => '{{WRAPPER}} .port-filter a',
			]
		);

		$this->add_responsive_control(
			'filter_margin',
			[
				'label' => __('Filter Container Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .port-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'filter_padding',
			[
				'label' => __('Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .port-filter a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);



		$this->add_responsive_control(
			'filter_linkmargin',
			[
				'label' => __('Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .port-filter a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'filter_border_radius',
			[
				'label' => __('Border Radius', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .port-filter a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'color_def',
			[
				'label' => __('Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-filter a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'color_bgdef',
			[
				'label' => __('Background Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-filter a' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'color_hov',
			[
				'label' => __('Color on Hover & Active', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-filter a.active' => 'color: {{VALUE}};',
					'{{WRAPPER}} .port-filter a:hover' => 'color: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'color_bgdefhover',
			[
				'label' => __('Background Color on Hover & Active', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-filter a.active' => 'background: {{VALUE}};',
					'{{WRAPPER}} .port-filter a::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .port-filter a::after' => 'background: {{VALUE}};',
					'{{WRAPPER}} .port-filter a:hover' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .port-filter a',
				'separator' => 'before',
			]
		);



		$this->add_control(
			'color_borderhover',
			[
				'label' => __('Border Color on Hover & Active', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-filter a:hover' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .port-filter a.active' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'port_mask',
			[
				'label' => __('Portfolio Mask Settings', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'mask_color',
			[
				'label' => __('Mask Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'mask_color2',
			[
				'label' => __('Second Mask Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box::after' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'mask_post2',
			[
				'label' => __('Second Mask Top Posisition (on hover)', 'anggita_plugin'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box::after' => 'top: {{SIZE}}%;',
				],
			]
		);

		$this->add_control(
			'mask_color_opacity',
			[
				'label' => __('Mask Color Opacity (on hover)', 'anggita_plugin'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'load_more_settings',
			[
				'label' => __('Load More Setting', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'load_text',
			[
				'label' => __('Load More Text color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .loadmore' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_text_hover',
			[
				'label' => __('Load More Text color on Hover', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .loadmore:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_text_bg',
			[
				'label' => __('Load More  Background Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .loadmore' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_text_hover_bg',
			[
				'label' => __('Load More  Background Color on Hover', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .loadmore:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_padding',
			[
				'label' => __('Load More Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .loadmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'load_margin',
			[
				'label' => __('Load More Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .loadmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'load_border',
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .loadmore',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'load_typography',
				'label'     => __('Load More Typography', 'anggita_plugin'),
				'selector'  => '{{WRAPPER}} .loadmore',
			]
		);

		$this->add_responsive_control(
			'load_align',
			[
				'label' => __('Filter Alignment', 'anggita_plugin'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'anggita_plugin'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'anggita_plugin'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __('Right', 'anggita_plugin'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => __('Justified', 'elementor'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'default' => 'center',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'no_more_settings',
			[
				'label' => __('No More Portfolio Setting', 'anggita_plugin'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'nomore_text',
			[
				'label' => __('No More Portfolio Text color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .nom-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'nomore_text_bg',
			[
				'label' => __('No More Portfolio Text  Background Color', 'anggita_plugin'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .nom-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'no-more_padding',
			[
				'label' => __('No More Portfolio Text Padding', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .nom-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'no-more_margin',
			[
				'label' => __('No More Portfolio Text Margin', 'anggita_plugin'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .nom-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'nomore_typography',
				'label'     => __('No More Portfolio Text Typography', 'anggita_plugin'),
				'selector'  => '{{WRAPPER}} .nom-btn',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings(); ?>




<div class="hidden rdn-port-val" data-nomore="<?php echo $settings['nomore']; ?>"
    data-item="<?php echo $settings['portfolio_item']; ?>" data-col="<?php echo $settings['port_column']; ?>"
    data-order="<?php echo $settings['port_order']; ?>" data-url="<?php echo admin_url('admin-ajax.php'); ?>"
    data-nonce="<?php echo wp_create_nonce("load_more_posts"); ?>"></div>
<ul class="port-filter center-port-filter">

    <?php
		$ridianur_taxonomy = 'portfolio_category';
		$ridianur_terms = get_terms($ridianur_taxonomy); // Get all terms of a taxonomy
		if ($ridianur_terms && !is_wp_error($ridianur_terms)) : ?>
    <li>
        <a class="active" href="#" data-filter="*">
            <?php if ($settings['filter_all']) {
						echo esc_html($settings['filter_all']);
					} else {
						esc_html_e('All', 'anggita_plugin');
					} ?>
        </a>
    </li>
    <?php foreach ($ridianur_terms as $ridianur_term) { ?>
    <li><a data-filter=".<?php echo  strtolower(preg_replace('/[^a-zA-Z]+/', '-', $ridianur_term->name)); ?>" href="#">
            <?php echo esc_attr($ridianur_term->name); ?></a></li>
    <?php }
	endif; ?>
</ul>



<div class="<?php if ($settings['port_style'] == '2') {
					echo "portfolio-type-two";
				} else if ($settings['port_style'] == '3') {
					echo "portfolio-type-three";
				} else {
					echo "portfolio-type-one";
				} ?> c-iso portfolio-body clearfix standard-port ">
    <?php
		$anggita_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		if ($settings['port_order'] != 'rand') {
			$order = 'order';
			$ord_val = $settings['port_order'];
		} else {
			$order = 'orderby';
			$ord_val = 'rand';
		}


		$ridianur_work = new \WP_Query(array(
			'paged' => $anggita_paged,
			'posts_per_page'   => $settings['portfolio_item'],
			'post_type' =>  'portfolio',
			$order       =>  $ord_val
		));


		if ($ridianur_work->have_posts()) : while ($ridianur_work->have_posts()) : $ridianur_work->the_post();
				global $post;

				?>

    <div class=" port-item <?php if ($settings['port_column'] == '3') {
											echo "col-md-4 ";
										} else if ($settings['port_column'] == '2') {
											echo "col-md-6 ";
										} else {
											echo "col-md-3 ";
										}
										$ridianur_terms = get_the_terms(get_the_ID(), 'portfolio_category');
										if (is_array($ridianur_terms) && count($ridianur_terms) > 0) {
											foreach ($ridianur_terms as $ridianur_term) {
												echo  strtolower(preg_replace('/[^a-zA-Z]+/', '-', $ridianur_term->name)) . ' ';
											}
										}
										$ridianur_allClasses = get_post_class();
										foreach ($ridianur_allClasses as $ridianur_class) {
											echo esc_attr($ridianur_class . " ");
										} ?>" id="post-<?php the_ID(); ?>">

        <div class="port-inner">
            <a class="port-link" href="<?php the_permalink(); ?>"></a>
            <div class="port-box"></div>
            <div class="port-img width-img img-bg"
                style="background-image:url(<?php echo get_the_post_thumbnail_url(); ?>);"></div>
            <div class="img-mask"></div>
            <div class="port-dbox">
                <div class="dbox-relative">
                    <h3><?php the_title(); ?></h3>
                    <div class="cleaboth clearfix"></div>
                    <?php $ridianur_taxonomy = 'portfolio_category';
								$ridianur_taxs = wp_get_post_terms($post->ID, $ridianur_taxonomy);  ?>
                    <p><?php $ridianur_cats = array();
									foreach ($ridianur_taxs as $ridianur_tax) {
										$ridianur_cats[] =   $ridianur_tax->name;
									}
									echo implode(', ', $ridianur_cats); ?></p>
                </div>
                <!--/.dbox-relative-->
            </div>
            <!--/.port-dbox-->
        </div>
        <!--/.port-inner-->



    </div>
    <!--.port-item-->

    <?php endwhile;

	else : ?>

    <div class="alert alert-warning">
        <?php _e('There is no Portfolio Post Found. You need to  choose 
		the portfolio category to show or create at least 1 portfolio post first.', 'anggita-plg'); ?>
    </div>
    <?php endif;
	wp_reset_postdata();  ?>



</div>
<?php
	if ($settings['load_show'] == 'Yes') {
		$ridianur_ports = new \WP_Query(
			array(
				'post_type' =>  'portfolio',
				'posts_per_page'  => $settings['portfolio_item'],
				'paged' => $anggita_paged
			)
		);
		// don't display the button if there are not enough posts
		if ($ridianur_ports->max_num_pages > 1) { ?>
<div class="box-<?php echo $settings['load_align']; ?> box-load clearfix">
    <div class="port-load">
        <div class="lds-ellipsis">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
    <div class="loadmore">
        <?php echo  $settings['load_more']; ?>
    </div>
</div>
<?php }
} ?>




<?php
}

/**
 * Render the widget output in the editor.
 *
 * Written as a Backbone JavaScript template and used to generate the live preview.
 *
 * @since 1.1.0
 *
 * @access protected
 */
protected function _content_template()
{ }
}