<?php
namespace AnggitaPlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


		
/**
 * @since 1.1.0
 */
class Anggita_OtherPortfolio extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'anggita-other-portfolio';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Anggita Related Portfolios', 'anggita_plugin' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-window-restore';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'anggita-portfolio-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
	
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Related Portfolio Settings', 'anggita_plugin' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title','anggita_plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => 'Insert your title..',
				'default' =>  __( 'Other Portfolio', 'anggita_plugin' ),
			]
		);
		
		$this->add_control(
			'subtitle',
			[
				'label' => __( 'Subtitle','anggita_plugin' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'placeholder' => 'Leave it blank if you don\'t want to use this subtitle',
				'default' =>  __( 'See our other portfolio', 'anggita_plugin' ),
			]
		);
	
		$this->add_control(
            'port_post',
            [
                'label' => __( 'Related Portfolio to show', 'anggita_plugin' ),
                'type' => Controls_Manager::NUMBER,
				'default' => '4',

            ]
        );
		
		$this->add_control(
			'port_column',
			[
				'label' => __( 'Related Portfolio Columns', 'anggita_plugin' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'two' => __( 'Two Columns', 'anggita_plugin' ),
					'three' => __( 'Three Columns', 'anggita_plugin' ),
					'four' => __( 'Four Columns', 'anggita_plugin' ),
				],
				'default' => 'four',
			]
		);

		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'title_section',
			[
				'label' => __( 'Title Settings', 'anggita_plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Margin', 'anggita_plugin' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .op-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'title_typo',
				'label'     => __( 'Title Typography', 'anggita_plugin' ),
				'selector'  => '{{WRAPPER}} .op-title',
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .op-title' => 'color: {{VALUE}};',
				],
			]
		);
	
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'text_section',
			[
				'label' => __( 'Subtitle Settings', 'anggita_plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'text_margin',
			[
				'label' => __( 'Margin', 'anggita_plugin' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .op-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'text_typo',
				'label'     => __( 'Subtitle Typography', 'anggita_plugin' ),
				'selector'  => '{{WRAPPER}} .op-sub',
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Color', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .op-sub' => 'color: {{VALUE}};',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Content Settings', 'anggita_plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		
		$this->add_responsive_control(
			'port_content',
			[
				'label' => __( 'Content Margin (on hover)', 'anggita_plugin' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'port_padding',
			[
				'label' => __( 'Content Padding (on hover)', 'anggita_plugin' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'bg_content',
			[
				'label' => __( 'Content Background', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'anggita_plugin' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'anggita_plugin' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'anggita_plugin' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'anggita_plugin' ),
						'icon' => 'fa fa-align-right',
					]
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative' => 'text-align: {{VALUE}};',
				],
			]
			
		);
		
		$this->add_control(
			'title_col',
			[
				'label' => __( 'Portfolio Title Color', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative h3' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'cattitle_col',
			[
				'label' => __( 'Portfolio Category Color', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .dbox-relative p' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'port_mask',
			[
				'label' => __( 'Portfolio Mask Settings', 'anggita_plugin' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		
		$this->add_control(
			'mask_color',
			[
				'label' => __( 'Mask Color', 'anggita_plugin' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'mask_color_opacity',
			[
				'label' => __( 'Mask Opacity (on hover)', 'anggita_plugin' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>0,
						'max' => 1,
						'step' =>0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .port-inner:hover .port-box' => 'opacity: {{SIZE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings();
		$this->add_render_attribute( 'title','class','op-title' );
		$this->add_render_attribute( 'subtitle','class','op-sub' );
		$this->add_inline_editing_attributes( 'title' , 'basic');
		$this->add_inline_editing_attributes( 'subtitle','basic' );
		$images = $this->get_settings( 'gallery' );

          // get the custom post type's ridianur_taxonomy terms
		  global $post;
          $custom_taxterms = wp_get_object_terms( $post->ID, 'portfolio_category', array('fields' => 'ids') );
		  $port_count = $settings['port_post'];
          // arguments
          $args = array(
              'post_type' => 'portfolio',
              'post_status' => 'publish',
              'posts_per_page' => $port_count, 
              'orderby' => 'rand',
              'tax_query' => array(
                  array(
                      'taxonomy' => 'portfolio_category',
                      'field' => 'id',
                      'terms' => $custom_taxterms
                      )
                  ),
              'post__not_in' => array ($post->ID),
          );
          $related_items = new \WP_Query( $args );
          // loop over query
          if ($related_items->have_posts()) : ?>
                  <div class="other-portfolio clearfix">
                  
                  
                  	  <?php if ($settings['subtitle']) { ?>
                      <p <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>><?php echo $settings['subtitle']; ?></p>
                      <?php } ?>
                      
                  	  <?php if ($settings['title']) { ?>
                      <h3 <?php echo $this->get_render_attribute_string( 'title' ); ?>><?php echo $settings['title']; ?></h3>
                      <?php } ?>
                      
                      
                      
                      <?php while ( $related_items->have_posts() ) : $related_items->the_post(); ?>
                      
                      <div class="<?php if ($settings['port_column'] == 'two') {echo "col-md-6"; }
                        if  ($settings['port_column'] == 'three') {echo "col-md-4"; } if  ($settings['port_column'] == 'four') {echo "col-md-3"; } ?> port-item">
                      
                          <div class="port-inner">
                              <a href="<?php the_permalink(); ?>" class="port-link"></a>
                              <div class="port-box"></div>
                              <div class="port-img width-img img-bg" style="background-image:url(<?php echo get_the_post_thumbnail_url(); ?>)"></div>
                              <div class="img-mask"></div>
                              <div class="port-dbox">
                                  <div class="dbox-relative">
                                      <h3><?php the_title(); ?></h3>
                                      <?php $ridianur_taxonomy = 'portfolio_category'; $args = array('number' => '1',); 
                                      $ridianur_taxs = wp_get_post_terms($post->ID,$ridianur_taxonomy,$args);  ?> 
                                      <p><?php $ridianur_cats = array();  foreach ( $ridianur_taxs as $ridianur_tax ) { $ridianur_cats[] =   $ridianur_tax->name ;   } 
                                      echo implode(', ', $ridianur_cats);?></p>
                                  </div><!--/.dbox-relative-->
                              </div><!--/.port-dbox-->
                          </div><!--/.port-inner-->
                      </div><!--.port-item-->
                         
                      <?php endwhile; ?>
                      
                  </div><!--/.other-portfolio-->  
              
          
          <?php  endif; wp_reset_postdata();
                 
		
		
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		
		
	}
}


