<?php
namespace AnggitaPlugin;

use AnggitaPlugin\Widgets\Anggita_Contact;
use AnggitaPlugin\Widgets\Anggita_Gallery;
use AnggitaPlugin\Widgets\Anggita_Logo;
use AnggitaPlugin\Widgets\Anggita_MasonGallery;
use AnggitaPlugin\Widgets\Anggita_Menu;
use AnggitaPlugin\Widgets\Anggita_OtherPortfolio;
use AnggitaPlugin\Widgets\Anggita_Portfolio;
use AnggitaPlugin\Widgets\Anggita_PortfolioAjax;
use AnggitaPlugin\Widgets\Anggita_PortfolioCustom;
use AnggitaPlugin\Widgets\Anggita_PortfolioCategory;
use AnggitaPlugin\Widgets\Anggita_PortfolioInfo;
use AnggitaPlugin\Widgets\Anggita_PortfolioMasonry;
use AnggitaPlugin\Widgets\Anggita_PortfolioTitle;
use AnggitaPlugin\Widgets\Anggita_Post;
use AnggitaPlugin\Widgets\Anggita_PostFour;
use AnggitaPlugin\Widgets\Anggita_PostSlider;
use AnggitaPlugin\Widgets\Anggita_PostThree;
use AnggitaPlugin\Widgets\Anggita_PostTwo;
use AnggitaPlugin\Widgets\Anggita_Share;
use AnggitaPlugin\Widgets\Anggita_Sidebar;
use AnggitaPlugin\Widgets\Anggita_Team;
use AnggitaPlugin\Widgets\Anggita_TeamHover;
use AnggitaPlugin\Widgets\Anggita_Testimonial;
use AnggitaPlugin\Widgets\Anggita_TextIcon;
use AnggitaPlugin\Widgets\Anggita_TextIconHover;
use AnggitaPlugin\Widgets\Anggita_TextLine;
use AnggitaPlugin\Widgets\Anggita_Title;
use AnggitaPlugin\Widgets\Rdn_Slider;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class AnggitaPlugin
{

    /**
     * Constructor
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function __construct()
    {
        $this->add_actions();
    }

    /**
     * Add Actions
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function add_actions()
    {
        //register all script
        add_action('elementor/widgets/widgets_registered', [$this, 'on_widgets_registered']);
        //isotope script
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('jquery-isotope', ANGGITA_URL . 'widgets/js/isotope.pkgd.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-portfolio-ajax', ANGGITA_URL . 'widgets/js/portfolio-ajax.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-portfolio-ajax-custom', ANGGITA_URL . 'widgets/js/portfolio-ajax-metro.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-portfolio', ANGGITA_URL . 'widgets/js/portfolio.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-portfolio-custom', ANGGITA_URL . 'widgets/js/portfolio-custom.js', array('jquery'), null, true);
        });
        //blog masonry script
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-blog-masonry', ANGGITA_URL . 'widgets/js/blog-mason.js', array('jquery'), null, true);
        });
        //slider script
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('jquery-slick', ANGGITA_URL . 'widgets/js/slick.min.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-animation', ANGGITA_URL . 'widgets/js/slick-animation.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-slider-script', ANGGITA_URL . 'widgets/js/slider.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-blog-slider-script', ANGGITA_URL . 'widgets/js/blog-slider.js', array('jquery'), null, true);
        });
        //gallery popup
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('jquery-magnificpopup', ANGGITA_URL . 'widgets/js/jquery.magnific-popup.min.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-gallery-popup', ANGGITA_URL . 'widgets/js/popup-gallery.js', array('jquery'), null, true);
        });
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-blog-script', ANGGITA_URL . 'widgets/js/blog.js', array('jquery'), null, true);
        });

        //gallery  masonry
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-masonry-gallery', ANGGITA_URL . 'widgets/js/mason-gallery.js', array('jquery'), null, true);
        });

        //share script
        add_action('elementor/frontend/after_register_scripts', function () {
            wp_register_script('anggita-share', ANGGITA_URL . 'widgets/js/share.js', array('jquery'), null, true);
        });
    }

    /**
     * On Widgets Registered
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function on_widgets_registered()
    {
        $this->includes();
        $this->register_widget();
    }

    /**
     * Includes
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function includes()
    {
        require __DIR__ . '/widgets/rdn-slider.php';
        require __DIR__ . '/widgets/portfolio.php';
        require __DIR__ . '/widgets/portfolio-ajax.php';
        require __DIR__ . '/widgets/portfolio-masonry.php';
        require __DIR__ . '/widgets/portfolio-custom.php';
        require __DIR__ . '/widgets/portfolio-info.php';
        require __DIR__ . '/widgets/portfolio-title.php';
        require __DIR__ . '/widgets/portfolio-category.php';
        require __DIR__ . '/widgets/title.php';
        require __DIR__ . '/widgets/testimonial.php';
        require __DIR__ . '/widgets/team.php';
        require __DIR__ . '/widgets/team-hover.php';
        require __DIR__ . '/widgets/text-line.php';
        require __DIR__ . '/widgets/text-icon.php';
        require __DIR__ . '/widgets/text-icon-hover.php';
        require __DIR__ . '/widgets/post.php';
        require __DIR__ . '/widgets/post-two.php';
        require __DIR__ . '/widgets/post-three.php';
        require __DIR__ . '/widgets/post-four.php';
        require __DIR__ . '/widgets/post-slider.php';
        require __DIR__ . '/widgets/menu.php';
        require __DIR__ . '/widgets/contact.php';
        require __DIR__ . '/widgets/other-portfolio.php';
        require __DIR__ . '/widgets/gallery.php';
        require __DIR__ . '/widgets/mason-gallery.php';
        require __DIR__ . '/widgets/logo.php';
        require __DIR__ . '/widgets/sidebar.php';
        require __DIR__ . '/widgets/share.php';
    }

    /**
     * Register Widget
     *
     * @since 1.0.0
     *
     * @access private
     */
    private function register_widget()
    {
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Rdn_Slider());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Portfolio());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioAjax());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioMasonry());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioCustom());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioInfo());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioTitle());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PortfolioCategory());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Title());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Team());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_TeamHover());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Testimonial());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_TextIcon());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_TextLine());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_TextIconHover());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Post());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PostTwo());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PostThree());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PostFour());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_PostSlider());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Menu());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Contact());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Gallery());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_MasonGallery());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_OtherPortfolio());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Logo());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Sidebar());
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Anggita_Share());
    }
}


new AnggitaPlugin();