<?php 



//CMB2 metabox
add_action( 'cmb2_admin_init', 'anggita_register_postsetting_metabox' );
function anggita_register_postsetting_metabox() {
	

	/**
	 * Custom Header Metabox
	 */
	$anggita_post_metabox_cmb2 = new_cmb2_box( array(
		'id'            => 'anggita_header_title_metabox',
		'title'         => esc_html__( 'Header Settings', 'anggita_plugin' ),
		'object_types'  => array( 'post','page','portfolio' ), // Post type
	) );

	
	$anggita_post_metabox_cmb2->add_field( array(
		'name'             => esc_html__( 'Header Options', 'anggita_plugin' ),
		'id'               => 'anggita_header_option',
		'type'             => 'select',
		'default' => 'global',
		'options'          => array(
			'global' => esc_html__( 'Use Global Setting (from Customizer).', 'anggita_plugin' ),
			'default'   => esc_html__( 'Use Default Header', 'anggita_plugin' ),
			'custom'   => esc_html__( 'Use Custom Header', 'anggita_plugin' ),
			'none'     => esc_html__( 'No Header', 'anggita_plugin' ),
		),
	) );
	
	$anggita_post_metabox_cmb2->add_field( array(
		'name'             => esc_html__( 'Header Format', 'anggita_plugin' ),
		'id'               => 'anggita_default_header',
		'type'             => 'select',
		'default' => 'head_clean',
		'options'          => array(
			'head_clean' => esc_html__( 'Black Text with White Background Header in Relative Position', 'anggita_plugin' ),
			'head_standard'   => esc_html__( 'White Text with Transparent Background Header in Absolute Position', 'anggita_plugin' ),
		),
	) );
	
	$anggita_post_metabox_cmb2->add_field( array(

		'name' => 'Choose Custom Header',
		'desc' => 'The Custom Header only appear on the actual page, not in elementor editor.',
		'id' => 'anggita_meta_choose_header',
		'type' => 'select',
		'options' =>choose_header(),
	) );
	
	/**
	 * Custom Footer Metabox
	 */
	$anggita_post_metabox_cmb2 = new_cmb2_box( array(
		'id'            => 'anggita_footer_title_metabox',
		'title'         => esc_html__( 'Footer Settings', 'anggita_plugin' ),
		'object_types'  => array( 'post','page','portfolio' ), // Post type
	) );

	
	$anggita_post_metabox_cmb2->add_field( array(
		'name'             => esc_html__( 'Footer Options', 'anggita_plugin' ),
		'id'               => 'anggita_footer_option',
		'type'             => 'select',
		'default' => 'global',
		'options'          => array(
			'global' => esc_html__( 'Use Global Setting (from Customizer).', 'anggita_plugin' ),
			'default'   => esc_html__( 'Use Default Footer', 'anggita_plugin' ),
			'custom'   => esc_html__( 'Use Custom Footer', 'anggita_plugin' ),
			'none'     => esc_html__( 'No Footer', 'anggita_plugin' ),
		),
	) );
	
	
	$anggita_post_metabox_cmb2->add_field( array(

		'name' => 'Choose Custom Footer',
		'desc' => 'The Custom Footer only appear on the actual page, not in elementor editor.',
		'id' => 'anggita_meta_choose_footer',
		'type' => 'select',
		'options' =>choose_footer(),
	) );
	

	
	
}//function end

//display header  list
function choose_header() {
    $header_posts = get_posts(['post_type' => 'header'] );
	$header = array();
	$i     = 0;
	foreach ( $header_posts as $header_post ) {
		if ( $i == 0 ) {
			$header_title = $header_post->post_title ;
			$i ++;
		}
		$header[ $header_post->ID ] = $header_post->post_title;
	}
	return $header;
}

//display footer  list
function choose_footer() {
    $footer_posts = get_posts(['post_type' => 'footer'] );
	$footer = array();
	$i     = 0;
	foreach ( $footer_posts as $footer_post ) {
		if ( $i == 0 ) {
			$footer_title = $footer_post->post_title ;
			$i ++;
		}
		$footer[ $footer_post->ID ] = $footer_post->post_title;
	}
	return $footer;
}



function anggita_metabox_scripts() {


// Registering and adding custom admin css
wp_enqueue_style( 'anggita_plugin_css', ANGGITA_URL  . 'inc/css/plugin-style.css', false, '1.0.0' );

// Adding custom admin scripts file
wp_enqueue_script( 'anggita_plugin_custom_script', ANGGITA_URL  . 'inc/js/plugin-script.js');
}

add_action( 'admin_enqueue_scripts', 'anggita_metabox_scripts' );


