<?php
// Registers the new post type 

function anggita_header_post_type() {
	register_post_type( 'header',
		array(
			'labels' => array(
				'name' => __( 'Custom Header', 'anggita_plugin' ),
				'singular_name' => __( 'Custom Header' , 'anggita_plugin'),
				'add_new' => __( 'Add New Custom Header', 'anggita_plugin' ),
				'add_new_item' => __( 'Add New Custom Header', 'anggita_plugin' ),
				'edit_item' => __( 'Edit Custom Header', 'anggita_plugin' ),
				'new_item' => __( 'Add New Custom Header', 'anggita_plugin' ),
				'view_item' => __( 'View Custom Header', 'anggita_plugin' ),
				'search_items' => __( 'Search Custom Header', 'anggita_plugin' ),
				'not_found' => __( 'No Custom Header found', 'anggita_plugin' ),
				'not_found_in_trash' => __( 'No Custom Header found in trash', 'anggita_plugin' )
			),
			'public' => true,
			'supports' => array( 'title'),
			'capability_type' => 'post',
			'rewrite' => array("slug" => "header"), // Permalinks format
			'menu_position' => 5,
			'menu_icon'           => 'dashicons-menu',
			'exclude_from_search' => true 
		)
	);

}

add_action( 'init', 'anggita_header_post_type' );


//add background in elementor editor
add_filter( 'body_class','my_body_classes' );

function my_body_classes( $classes ) {
 	if ( is_singular('header') ) {
	global $post;
    $classes[] = get_post_meta($post->ID, 'anggita_dark_bg', true);  
    }  
    return $classes;

}

