<?php

//KIRKI OPTIONS

Kirki::add_config('anggita_config', array(
    'capability' => 'edit_theme_options',
    'option_type' => 'theme_mod',
));

//Color schemes section
Kirki::add_section('anggita_color_customizer', array(
    'title' => esc_html__('Color Settings', 'anggita_plugin'),
    'description' => esc_html__('Most of the color scheme/settings below only affect on the element/page that not using the elementor page builder.', 'anggita_plugin'),
    'priority' => 21,
));

//Fields inside color schemes

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_colorschemes',
    'label' => esc_html__('Color schemes', 'anggita_plugin'),
    'description' => esc_html__('Pick your color scheme. ', 'anggita_plugin'),
    'section' => 'anggita_color_customizer',
    'choices' => [
        'alpha' => true,
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_color_link',
    'label' => esc_html__('Hyperlink Color', 'anggita_plugin'),
    'description' => esc_html__('Pick your color for hyperlink.', 'anggita_plugin'),
    'section' => 'anggita_color_customizer',
    'choices' => [
        'alpha' => true,
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_color_link_hover',
    'label' => esc_html__('Hyperlink color on hover state', 'anggita_plugin'),
    'description' => esc_html__('Pick your color for hover state in hyperlink.', 'anggita_plugin'),
    'section' => 'anggita_color_customizer',
    'choices' => [
        'alpha' => true,
    ],
]);

//Preloader section
Kirki::add_section('anggita_preloader_section', array(
    'title' => esc_html__('Preloader Settings', 'anggita_plugin'),
    'priority' => 22,
));

//Preloader fields
Kirki::add_field('anggita_config', [
    'type' => 'select',
    'settings' => 'anggita_preloader_show',
    'label' => esc_html__('Choose Preloader setting', 'anggita_plugin'),
    'section' => 'anggita_preloader_section',
    'default' => 'hide',
    'priority' => 1,
    'multiple' => 1,
    'choices' => [
        'home' => esc_html__('Show only in homepage', 'anggita_plugin'),
        'all' => esc_html__('Show in all pages', 'anggita_plugin'),
        'hide' => esc_html__('Hide in all pages', 'anggita_plugin'),
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_bg_preloader',
    'label' => esc_html__('Preloader Background Color', 'anggita_plugin'),
    'description' => esc_html__('Choose your background color for preloader.', 'anggita_plugin'),
    'section' => 'anggita_preloader_section',
    'choices' => [
        'alpha' => true,
    ],
]);



//field in site identity

//Site branding/logo white text
Kirki::add_field('anggita_config', [
    'type' => 'image',
    'settings' => 'anggita_logo_image_white',
    'label' => esc_html__('Logo for Header White Text', 'anggita_plugin'),
    'description' => wp_kses_post('Upload your logo only for white text (standard) header here. <br/>Recommended size 240x80px', 'anggita_plugin'),
    'section' => 'title_tagline',
    'default' => '',
]);

//Site branding/logo black text
Kirki::add_field('anggita_config', [
    'type' => 'image',
    'settings' => 'anggita_logo_image',
    'label' => esc_html__('Logo for Header Black Text', 'anggita_plugin'),
    'description' => wp_kses_post('Upload your logo only for black text (standard) header here. <br/>Recommended size 240x80px', 'anggita_plugin'),
    'section' => 'title_tagline',
    'default' => '',
]);

//Social icon in header section
Kirki::add_section('anggita_customizer_header', array(
    'title' => esc_html__('Social Icon in Header', 'anggita_plugin'),
    'description' => esc_html__('Settings for the social icon in header area (standard header).', 'anggita_plugin'),
    'priority' => 23,
));

//field in social icon
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'fb_social_head',
    'label' => esc_html__('Facebook link', 'anggita_plugin'),
    'section' => 'anggita_customizer_header',
    'description' => esc_html__('Insert your Facebook link here', 'anggita_plugin'),
    'priority' => 12,
]);
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'lkd_social_head',
    'label' => esc_html__('Linkedin link', 'anggita_plugin'),
    'section' => 'anggita_customizer_header',
    'description' => esc_html__('Insert your Linkedin link here', 'anggita_plugin'),
    'priority' => 12,
]);
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'tw_social_head',
    'label' => esc_html__('Twitter link', 'anggita_plugin'),
    'section' => 'anggita_customizer_header',
    'description' => esc_html__('Insert your Google Plus link here', 'anggita_plugin'),
    'priority' => 12,
]);
//repeater
Kirki::add_field('anggita_config', [
    'type' => 'repeater',
    'label' => esc_html__('Other Social Icon', 'anggita_plugin'),
    'description' => esc_html__('Insert the social icon.', 'anggita_plugin'),
    'section' => 'anggita_customizer_header',
    'default' => [
        [
            'link_text' => '',
            'link_url' => '',
        ],
    ],
    'priority' => 13,
    'row_label' => [
        'type' => 'text',
        'value' => esc_html__('Custom Social Icon. ', 'anggita_plugin'),
    ],
    'button_label' => esc_html__('New social icon', 'anggita_plugin'),
    'settings' => 'social_icon',
    'fields' => [
        'link_text' => [
            'type' => 'text',
            'label' => esc_html__('Social Icon', 'anggita_plugin'),
            'description' => wp_kses_post('Input your social icon here. See the list  <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">here.</a> <br>eg. <b>fa-github</b>', 'anggita_plugin'),
            'default' => '',
        ],
        'link_url' => [
            'type' => 'text',
            'label' => esc_html__('Social Icon link', 'anggita_plugin'),
            'description' => esc_html__('Insert the custom social icon link here.', 'anggita_plugin'),
            'default' => '',
        ],
    ],
]);

//PANEL FOR PAGE SETTINGS
Kirki::add_panel('anggita_page_panel', array(
    'priority' => 24,
    'title' => esc_html__('Page Settings', 'anggita_plugin'),
));

//PORTFOLIO PAGE SECTION
Kirki::add_section('anggita_cst_portfolio_page', array(
    'title' => esc_html__('Portfolio Page', 'anggita_plugin'),
    'description' => esc_html__('Settings for portfolio page.', 'anggita_plugin'),
    'panel' => 'anggita_page_panel',
));

Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'other_portfolio_title_text',
    'label' => esc_html__('Other Portfolio Section Title', 'anggita_plugin'),
    'section' => 'anggita_cst_portfolio_page',
    'description' => wp_kses_post('Insert your text for title of other portfolio section on single portfolio page.<br/>Leave it blank if you want to use the default text.', 'anggita_plugin'),
]);

Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'other_portfolio_subtitle_text',
    'label' => esc_html__('Other Portfolio Section Subtitle', 'anggita_plugin'),
    'section' => 'anggita_cst_portfolio_page',
    'description' => wp_kses_post('Insert your text for subtitle of other portfolio section on single portfolio page.<br/>Leave it blank if you want to use the default text.', 'anggita_plugin'),
]);

//BLOG PAGE SECTION
Kirki::add_section('anggita_cst_blog_page', array(
    'title' => esc_html__('Blog Page', 'anggita_plugin'),
    'description' => esc_html__('Settings for blog page.', 'anggita_plugin'),
    'panel' => 'anggita_page_panel',
));

Kirki::add_field('anggita_config', [
    'type' => 'slider',
    'settings' => 'anggita_blog_slider_delay',
    'label' => esc_html__('Blog Slider Delay', 'anggita_plugin'),
    'description' => esc_html__('Insert the slider delay for slider in blog sidebar,blog wide and single blog post here. The default value 8000', 'anggita_plugin'),
    'section' => 'anggita_cst_blog_page',
    'default' => 8000,
    'choices' => [
        'min' => 0,
        'max' => 20000,
        'step' => 100,
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'switch',
    'settings' => 'anggita_related_image',
    'label' => esc_html__('Featured Image in Related Posts', 'anggita_plugin'),
    'section' => 'anggita_cst_blog_page',
    'description' => wp_kses_post('Turn on/off the featured images in related posts. The default value is off.', 'anggita_plugin'),
    'default' => '',
]);


//HEADER SECTION
Kirki::add_section('anggita_header_cst_settings', array(
    'title' => esc_html__('Header Settings', 'anggita_plugin'),
    'priority' => 25,
));

//CUSTOM HEADER FIELD
Kirki::add_field('anggita_config', [
    'type' => 'select',
    'settings' => 'custom_header_setting_value',
    'label' => esc_html__('Header Setting(global)', 'anggita_plugin'),
    'description' => wp_kses_post('<p>Choose Header type for all pages but you still can set different/overwrite header type for specific page in page/post settings. </p><p><b>Standard Header</b> is Black text with white background header in relative position.</p>', 'anggita_plugin'),
    'section' => 'anggita_header_cst_settings',
    'default' => 'standard',
    'priority' => 10,
    'multiple' => 1,
    'choices' => [
        'standard' => esc_html__('Standard Header', 'anggita_plugin'),
        'custom' => esc_html__('Custom Header', 'anggita_plugin'),
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'select',
    'settings' => 'anggita_select_header',
    'label' => esc_html__('Select the custom header', 'anggita_plugin'),
    'section' => 'anggita_header_cst_settings',
    'multiple' => 1,
    'placeholder' => esc_attr__('Select the header', 'kirki'),
    'choices' => Kirki_Helper::get_posts(array('post_type' => 'header')),

    //conditional/only appear in value
    'required' => array(
        array(
            'setting' => 'custom_header_setting_value',
            'value' => 'custom',
            'operator' => '==',
        ),
    ),

]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_all_header_bg_color',
    'label' => esc_html__('Sticky Menu Background color (for menu with black background & All Sticky Custom Menu)', 'anggita_plugin'),
    'description' => esc_html__('Pick your background color for sticky menu in white text header. Default color is #1f1f1f', 'anggita_plugin'),
    'section' => 'anggita_header_cst_settings',
    'default' => '#1f1f1f',
    'choices' => [
        'alpha' => true,
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_white_header_bg_color',
    'label' => esc_html__('Sticky Menu Background color (for menu with white background)', 'anggita_plugin'),
    'description' => esc_html__('Pick your background color for sticky menu in white text header. Default color is #ffffff', 'anggita_plugin'),
    'section' => 'anggita_header_cst_settings',
    'default' => '#ffffff',
    'choices' => [
        'alpha' => true,
    ],
]);

//FOOTER SECTION
Kirki::add_section('anggita_footer_cst_settings', array(
    'title' => esc_html__('Footer Settings', 'anggita_plugin'),
    'priority' => 26,
));

//CUSTOM FOOTER FIELD
Kirki::add_field('anggita_config', [
    'type' => 'select',
    'settings' => 'custom_footer_setting_value',
    'label' => esc_html__('Footer Setting(global)', 'anggita_plugin'),
    'description' => wp_kses_post('<p>Choose Footer type for all pages but you still can set different/overwrite footer type for specific page in page/post settings. </p><p><b>Standard Header</b> is Black text with white background header in relative position.</p>', 'anggita_plugin'),
    'section' => 'anggita_footer_cst_settings',
    'default' => 'standard',
    'priority' => 10,
    'multiple' => 1,
    'choices' => [
        'standard' => esc_html__('Standard Footer', 'anggita_plugin'),
        'custom' => esc_html__('Custom Footer', 'anggita_plugin'),
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'select',
    'settings' => 'anggita_select_footer',
    'label' => esc_html__('Select the custom footer', 'anggita_plugin'),
    'section' => 'anggita_footer_cst_settings',
    'placeholder' => esc_attr__('Select the footer', 'kirki'),
    'multiple' => 1,
    'choices' => Kirki_Helper::get_posts(array('post_type' => 'footer')),

    //conditional/only appear in value
    'required' => array(
        array(
            'setting' => 'custom_footer_setting_value',
            'value' => 'custom',
            'operator' => '==',
        ),
    ),

]);

Kirki::add_field('anggita_config', [
    'type' => 'color',
    'settings' => 'anggita_default_footer_bg_color',
    'label' => esc_html__('Standard Footer Background color', 'anggita_plugin'),
    'description' => esc_html__('Pick your background color for standard footer. Default color is black #000000', 'anggita_plugin'),
    'section' => 'anggita_footer_cst_settings',
    'default' => '#000000',
    'choices' => [
        'alpha' => true,
    ],
    //conditional/only appear in value
    'required' => array(
        array(
            'setting' => 'custom_footer_setting_value',
            'value' => 'standard',
            'operator' => '==',
        ),
    ),
]);

Kirki::add_field('anggita_config', [
    'type' => 'image',
    'settings' => 'anggita_footer_logo',
    'label' => esc_html__('Standard Footer Image', 'anggita_plugin'),
    'description' => esc_html__('Upload your footer image for standard footer here. Recommended size 240x120px', 'anggita_plugin'),
    'section' => 'anggita_footer_cst_settings',
    'default' => '',
    //conditional/only appear in value
    'required' => array(
        array(
            'setting' => 'custom_footer_setting_value',
            'value' => 'standard',
            'operator' => '==',
        ),
    ),
]);

Kirki::add_field('anggita_config', [
    'type' => 'editor',
    'settings' => 'anggita_footer_text',
    'label' => esc_html__('Standard Footer Text', 'kirki'),
    'description' => esc_html__('Input standard footer text here.', 'kirki'),
    'section' => 'anggita_footer_cst_settings',
    //conditional/only appear in value
    'required' => array(
        array(
            'setting' => 'custom_footer_setting_value',
            'value' => 'standard',
            'operator' => '==',
        ),
    ),
]);

//Social icon in footer section
Kirki::add_section('anggita_customizer_footer_icon', array(
    'title' => esc_html__('Social Icon in Footer', 'anggita_plugin'),
    'description' => esc_html__('Settings for the social icon in footer area (standard footer).', 'anggita_plugin'),
    'priority' => 27,
));

//field in social icon
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'fb_social_foot',
    'label' => esc_html__('Facebook link', 'anggita_plugin'),
    'section' => 'anggita_customizer_footer_icon',
    'description' => esc_html__('Insert your Facebook link here', 'anggita_plugin'),
    'priority' => 12,
]);
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'lkd_social_foot',
    'label' => esc_html__('Linkedin link', 'anggita_plugin'),
    'section' => 'anggita_customizer_footer_icon',
    'description' => esc_html__('Insert your Linkedin link here', 'anggita_plugin'),
    'priority' => 12,
]);
Kirki::add_field('anggita_config', [
    'type' => 'text',
    'settings' => 'tw_social_foot',
    'label' => esc_html__('Twitter link', 'anggita_plugin'),
    'section' => 'anggita_customizer_footer_icon',
    'description' => esc_html__('Insert your Google Plus link here', 'anggita_plugin'),
    'priority' => 12,
]);
//repeater
Kirki::add_field('anggita_config', [
    'type' => 'repeater',
    'label' => esc_html__('Other Social Icon', 'anggita_plugin'),
    'description' => esc_html__('Insert the social icon.', 'anggita_plugin'),
    'section' => 'anggita_customizer_footer_icon',
    'priority' => 13,
    'row_label' => [
        'type' => 'text',
        'value' => esc_html__('Custom Social Icon. ', 'anggita_plugin'),
    ],
    'button_label' => esc_html__('New social icon', 'anggita_plugin'),
    'default' => [
        [
            'link_text_foot' => '',
            'link_url_foot' => '',
        ],
    ],
    'settings' => 'social_icon_footer',
    'fields' => [
        'link_text_foot' => [
            'type' => 'text',
            'label' => esc_html__('Social Icon', 'anggita_plugin'),
            'description' => wp_kses_post('Input your social icon here. See the list  <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">here.</a> <br>eg. <b>fa-github</b>', 'anggita_plugin'),
            'default' => '',
        ],
        'link_url_foot' => [
            'type' => 'text',
            'label' => esc_html__('Social Icon link', 'anggita_plugin'),
            'description' => esc_html__('Insert the custom social icon link here.', 'anggita_plugin'),
            'default' => '',
        ],
    ],
]);

//TYPOGRAPHY SECTION
Kirki::add_section('anggita_cst_typography', array(
    'title' => esc_html__('Typography Settings', 'anggita_plugin'),
    'description' => wp_kses_post('<p>Some text/font only can be changed by elementor or custom css.</p> <p>You can use <b>px,em,rem</b> for Font Size/Line Height/Letter Spacing value.</p> <p>Example value: <b>15em</b></p>', 'kirki'),
    'priority' => 28,
));

//TYPOGRAPHY FIELD
Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_one',
    'label' => esc_html__('H1 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h1',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_two',
    'label' => esc_html__('H2 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h2',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_three',
    'label' => esc_html__('H3 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h3',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_four',
    'label' => esc_html__('H4 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h4',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_five',
    'label' => esc_html__('H5 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h5',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_five',
    'label' => esc_html__('H6 Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'h6',
        ],
    ],
]);


Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_heading_five',
    'label' => esc_html__('Blog Title Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Poppins',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => '.blog-title,h1.blog-title',
        ],
    ],
]);

Kirki::add_field('anggita_config', [
    'type' => 'typography',
    'settings' => 'anggita_paragraph_font',
    'label' => esc_html__('Paragraph Font', 'anggita_plugin'),
    'section' => 'anggita_cst_typography',
    'default' => [
        'font-family' => 'Heebo',
        'variant' => '',
        'font-size' => '',
        'line-height' => '',
        'letter-spacing' => '',
        'color' => '',
    ],
    'transport' => 'auto',
    'output' => [
        [
            'element' => 'body',
        ],
    ],
]);